/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.resolver.query.AbstractBulkQueryResolverTestCase;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.StaticBulkQueryResolver;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StaticBulkQueryResolverTestCase
extends AbstractBulkQueryResolverTestCase {
    @Test
    public void doesNotResolvesBulkQueryWhenThereIsNoEvent() throws Exception {
        StaticBulkQueryResolver bulkQueryResolver = new StaticBulkQueryResolver("delete from test1;\ndelete from test2", null);
        BulkQuery resolvedBulkQuery = bulkQueryResolver.resolve(null);
        Assert.assertThat((Object)resolvedBulkQuery, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=QueryResolutionException.class)
    public void throwsErrorOnEmptyBulkQuery() throws Exception {
        StaticBulkQueryResolver bulkQueryResolver = new StaticBulkQueryResolver("", null);
        bulkQueryResolver.resolve(this.muleEvent);
    }

    @Test
    public void resolvesStaticBulkQuery() throws Exception {
        QueryTemplateParser queryTemplateParser = this.createQueryTemplateParser();
        StaticBulkQueryResolver bulkQueryResolver = new StaticBulkQueryResolver("delete from test1;\ndelete from test2", queryTemplateParser);
        BulkQuery resolvedBulkQuery = bulkQueryResolver.resolve(this.muleEvent);
        this.assertResolvedBulkQuery(resolvedBulkQuery);
    }

    @Test
    public void cachesResolvedBulkQueries() throws Exception {
        QueryTemplateParser queryTemplateParser = this.createQueryTemplateParser();
        StaticBulkQueryResolver bulkQueryResolver = new StaticBulkQueryResolver("delete from test1;\ndelete from test2", queryTemplateParser);
        BulkQuery resolvedBulkQuery1 = bulkQueryResolver.resolve(this.muleEvent);
        BulkQuery resolvedBulkQuery2 = bulkQueryResolver.resolve(this.muleEvent);
        Assert.assertThat((Object)resolvedBulkQuery1, (Matcher)CoreMatchers.sameInstance((Object)resolvedBulkQuery2));
        ((QueryTemplateParser)Mockito.verify((Object)queryTemplateParser, (VerificationMode)Mockito.times((int)2))).parse(Matchers.anyString());
    }
}

