/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.List;
import org.mule.module.db.internal.domain.type.AbstractStructuredDbType;

public class ArrayResolvedDbType
extends AbstractStructuredDbType {
    public ArrayResolvedDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (!(value instanceof Array)) {
            Connection connection = statement.getConnection();
            if (value instanceof Object[]) {
                value = connection.createArrayOf(this.name, (Object[])value);
            } else if (value instanceof List) {
                value = connection.createArrayOf(this.name, ((List)value).toArray());
            } else {
                throw new IllegalArgumentException(ArrayResolvedDbType.createUnsupportedTypeErrorMessage(value));
            }
        }
        statement.setArray(index, (Array)value);
    }

    protected static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a %s from a value of type %s", Struct.class.getName(), value.getClass());
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        return statement.getArray(index);
    }
}

