/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.FieldDebugInfoFactory;
import org.mule.api.debug.SimpleFieldDebugInfo;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.QueryResolver;

public abstract class AbstractSingleQueryDbMessageProcessor
extends AbstractDbMessageProcessor {
    private final QueryResolver queryResolver;

    public AbstractSingleQueryDbMessageProcessor(DbConfigResolver dbConfigResolver, QueryResolver queryResolver, TransactionalAction transactionalAction) {
        super(dbConfigResolver, transactionalAction);
        this.queryResolver = queryResolver;
    }

    @Override
    protected Object executeQuery(DbConnection connection, MuleEvent muleEvent) throws SQLException {
        MuleEvent eventToUse = this.resolveSource(muleEvent);
        Query resolvedQuery = this.queryResolver.resolve(connection, eventToUse);
        this.validateQueryType(resolvedQuery.getQueryTemplate());
        return this.doExecuteQuery(connection, resolvedQuery);
    }

    protected abstract Object doExecuteQuery(DbConnection var1, Query var2) throws SQLException;

    @Override
    protected List<FieldDebugInfo<?>> getMessageProcessorDebugInfo(DbConnection connection, MuleEvent muleEvent) {
        Query resolvedQuery;
        MuleEvent eventToUse = this.resolveSource(muleEvent);
        ArrayList fields = new ArrayList();
        try {
            resolvedQuery = this.queryResolver.resolve(connection, eventToUse);
        }
        catch (QueryResolutionException e) {
            fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"SQL", String.class, (Exception)e));
            return fields;
        }
        fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"SQL", String.class, (Object)resolvedQuery.getQueryTemplate().getSqlText()));
        fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Type", String.class, (Object)resolvedQuery.getQueryTemplate().getType().toString()));
        ArrayList<SimpleFieldDebugInfo> paramFields = new ArrayList<SimpleFieldDebugInfo>();
        int paramIndex = 1;
        for (QueryParamValue queryParamValue : resolvedQuery.getParamValues()) {
            String name = queryParamValue.getName() == null ? "param " + paramIndex++ : queryParamValue.getName();
            paramFields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)name, String.class, (Object)queryParamValue.getValue()));
        }
        fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Input params", List.class, paramFields));
        return fields;
    }
}

