/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.matcher;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.FieldUtils;
import org.mule.module.db.integration.model.Record;

public class FieldMatcher
extends TypeSafeMatcher<Record> {
    private final Field field;

    public FieldMatcher(Field field) {
        this.field = field;
    }

    public boolean matchesSafely(Record item) {
        return item.getFields().contains(this.field);
    }

    public void describeTo(Description description) {
        description.appendText("Does not contains a field with name = " + this.field.getName() + " with value = " + FieldUtils.getValueAsString(this.field.getValue()));
    }

    @Factory
    public static Matcher<Record> containsField(Field field) {
        return new FieldMatcher(field);
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText("was ").appendValue((Object)FieldUtils.getValueAsString(item));
    }
}

