/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Contact;
import org.mule.module.db.integration.model.OracleTestDatabase;
import org.mule.module.db.integration.model.Region;

public class StoredProcedureJavaArrayUdtTestCase
extends AbstractDbIntegrationTestCase {
    public StoredProcedureJavaArrayUdtTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        if (!TestDbConfig.getOracleResource().isEmpty()) {
            params.add(new Object[]{"integration/config/oracle-mapped-udt-db-config.xml", new OracleTestDatabase()});
        }
        return params;
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/storedprocedure/stored-procedure-udt-array-config.xml"};
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        DataSource dataSource = this.getDefaultDataSource();
        this.testDatabase.createStoredProcedureGetZipCodes(dataSource);
        this.testDatabase.createStoredProcedureGetContactDetails(dataSource);
    }

    @Test
    public void returnsDefaultArray() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://returnsDefaultArrayValue", (Object)"Test Message", null);
        MatcherAssert.assertThat((Object)response.getPayload(), (Matcher)Matchers.equalTo((Object)Region.SOUTHWEST.getZips()));
    }

    @Test
    public void returnsCustomArray() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://returnsCustomArrayValue", (Object)"Test Message", null);
        MatcherAssert.assertThat((Object)response.getPayload(), (Matcher)Matchers.equalTo((Object)Contact.CONTACT1.getDetails()));
    }
}

