/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.type.ArrayResolvedDbType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ArrayResolvedDbTypeTestCase
extends AbstractMuleTestCase {
    private static final int PARAM_INDEX = 1;
    private static final String TYPE_NAME = "testStruct";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ArrayResolvedDbType dataType;
    private PreparedStatement statement;
    private Connection connection;
    private Array dbArray;

    @Before
    public void setUp() throws Exception {
        this.dataType = new ArrayResolvedDbType(2003, TYPE_NAME);
        this.statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.dbArray = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)this.statement.getConnection()).thenReturn((Object)this.connection);
    }

    @Test
    public void convertsJavaArray() throws Exception {
        Object[] value = new Object[]{"foo", "bar"};
        Mockito.when((Object)this.connection.createArrayOf(TYPE_NAME, value)).thenReturn((Object)this.dbArray);
        this.dataType.setParameterValue(this.statement, 1, (Object)value);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setArray(1, this.dbArray);
    }

    @Test
    public void convertsList() throws Exception {
        ArrayList<String> value = new ArrayList<String>();
        value.add("foo");
        value.add("bar");
        Mockito.when((Object)this.connection.createArrayOf((String)Matchers.argThat((Matcher)org.hamcrest.Matchers.equalTo((Object)TYPE_NAME)), (Object[])Matchers.argThat((Matcher)org.hamcrest.Matchers.arrayContaining((Object[])new String[]{"foo", "bar"})))).thenReturn((Object)this.dbArray);
        this.dataType.setParameterValue(this.statement, 1, value);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setArray(1, this.dbArray);
    }

    @Test
    public void failsToConvertUnsupportedType() throws Exception {
        Object value = new Object();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(org.hamcrest.Matchers.containsString((String)ArrayResolvedDbType.createUnsupportedTypeErrorMessage((Object)value)));
        this.dataType.setParameterValue(this.statement, 1, value);
    }
}

