/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.parser.QueryTemplateParsingException;
import org.mule.module.db.internal.resolver.query.AbstractQueryResolverTestCase;
import org.mule.module.db.internal.resolver.query.DynamicQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DynamicQueryResolverTestCase
extends AbstractQueryResolverTestCase {
    private final Query query = this.createQuery(this.createQueryTemplate("select * from #[table]"));

    @Test
    public void resolvesDynamicQuery() throws Exception {
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        String staticSqlText = "select * from test";
        Mockito.when((Object)expressionManager.parse("select * from #[table]", this.muleEvent)).thenReturn((Object)staticSqlText);
        QueryTemplate expectedQueryTemplate = this.createQueryTemplate(staticSqlText);
        QueryTemplateParser queryTemplateParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        Mockito.when((Object)queryTemplateParser.parse(staticSqlText)).thenReturn((Object)expectedQueryTemplate);
        DynamicQueryResolver queryResolver = new DynamicQueryResolver(this.query, queryTemplateParser, expressionManager);
        Query resolvedQuery = queryResolver.resolve(null, this.muleEvent);
        Assert.assertThat((Object)expectedQueryTemplate, (Matcher)IsSame.sameInstance((Object)resolvedQuery.getQueryTemplate()));
    }

    @Test(expected=QueryResolutionException.class)
    public void throwsErrorOnParsingError() throws Exception {
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        String staticSqlText = "select * from test";
        Mockito.when((Object)expressionManager.parse("select * from #[table]", this.muleEvent)).thenReturn((Object)staticSqlText);
        QueryTemplateParser queryTemplateParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        Mockito.when((Object)queryTemplateParser.parse(staticSqlText)).thenThrow(new Throwable[]{new QueryTemplateParsingException("Parse error")});
        DynamicQueryResolver queryResolver = new DynamicQueryResolver(this.query, queryTemplateParser, expressionManager);
        queryResolver.resolve(null, this.muleEvent);
    }

    @Test(expected=QueryResolutionException.class)
    public void throwsErrorOnExpressionEvaluationError() throws Exception {
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)expressionManager.parse("select * from #[table]", this.muleEvent)).thenThrow(new Throwable[]{new ExpressionRuntimeException(CoreMessages.createStaticMessage((String)"Error"))});
        DynamicQueryResolver queryResolver = new DynamicQueryResolver(this.query, null, expressionManager);
        queryResolver.resolve(null, this.muleEvent);
    }
}

