/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration;

import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.transport.NullPayload;

public abstract class AbstractQueryTimeoutTestCase
extends AbstractDbIntegrationTestCase {
    public static final String QUERY_TIMEOUT_FLOW = "queryTimeout";

    public AbstractQueryTimeoutTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Test
    public void timeoutsQuery() throws Exception {
        MuleEvent responseEvent = this.runFlow(QUERY_TIMEOUT_FLOW, 0);
        MuleMessage response = responseEvent.getMessage();
        MatcherAssert.assertThat((Object)response.getExceptionPayload(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)response.getPayload(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.instanceOf(NullPayload.class))));
        try {
            this.runFlow(QUERY_TIMEOUT_FLOW, 5);
            TestCase.fail((String)"Expected query to timeout");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    @Before
    public void setupDelayFunction() throws Exception {
        this.testDatabase.createDelayFunction(this.getDefaultDataSource());
    }
}

