/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.sql.SQLException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public class UpdateDefaultTestCase
extends AbstractDbIntegrationTestCase {
    public UpdateDefaultTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-default-config.xml"};
    }

    @Test
    public void updatesDataRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://updateRequestResponse", (Object)"Test Message", null);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        this.verifyUpdatedRecord();
    }

    @Test
    public void updatesDataOneWay() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://updateOneWay", (Object)"Test Message", null);
        MuleMessage response = client.request("vm://testOut", 5000L);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        this.verifyUpdatedRecord();
    }

    private void verifyUpdatedRecord() throws SQLException {
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }
}

