/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.ConnectionCreationException;
import org.mule.module.db.internal.domain.connection.SimpleConnectionFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SimpleConnectionFactoryTestCase
extends AbstractMuleTestCase {
    private final SimpleConnectionFactory connectionFactory = new SimpleConnectionFactory(null);
    private final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);

    @Test
    public void createsConnection() throws Exception {
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)expectedConnection);
        Connection connection = this.connectionFactory.create(this.dataSource);
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.equalTo((Object)expectedConnection));
    }

    @Test(expected=ConnectionCreationException.class)
    public void failsOnConnectionError() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenThrow(new Throwable[]{new RuntimeException()});
        this.connectionFactory.create(this.dataSource);
    }

    @Test(expected=ConnectionCreationException.class)
    public void failsOnNullConnection() throws Exception {
        Object expectedConnection = null;
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(expectedConnection);
        this.connectionFactory.create(this.dataSource);
    }
}

