/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.security.oauth.process;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.security.oauth.callback.ProcessCallback;

public class ProcessCallbackProcessInterceptor<T, O> implements ProcessInterceptor<T, O>
{

    public T execute(ProcessCallback<T, O> processCallback,
                     O object,
                     MessageProcessor messageProcessor,
                     MuleEvent event) throws Exception
    {
        return processCallback.process(object);
    }

    public T execute(ProcessCallback<T, O> processCallback, O object, Filter filter, MuleMessage message)
        throws Exception
    {
        return processCallback.process(object);
    }

}
