/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ParameterizableTypeElement;
import org.mule.runtime.module.extension.internal.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class SourceTypeWrapper<T extends Source>
extends TypeWrapper
implements SourceElement,
ParameterizableTypeElement {
    private final Class<T> aClass;

    SourceTypeWrapper(Class<T> aClass) {
        super(aClass);
        this.aClass = aClass;
    }

    @Override
    public Class<? extends Source> getDeclaringClass() {
        return this.aClass;
    }

    @Override
    public List<Type> getSuperClassGenerics() {
        return IntrospectionUtils.getSuperClassGenerics(this.aClass, Source.class);
    }

    @Override
    public Optional<MethodElement> getOnResponseMethod() {
        return this.getMethodAnnotatedWith(OnSuccess.class);
    }

    @Override
    public Optional<MethodElement> getOnErrorMethod() {
        return this.getMethodAnnotatedWith(OnError.class);
    }

    private Optional<MethodElement> getMethodAnnotatedWith(Class<? extends Annotation> annotationType) {
        Collection<Method> methods = IntrospectionUtils.getMethodsAnnotatedWith(this.aClass, annotationType);
        if (methods.isEmpty()) {
            return Optional.empty();
        }
        if (methods.size() > 1) {
            throw new IllegalSourceModelDefinitionException(String.format("Source declared in class '%s' declares more than one method annotated with '%s'", this.aClass.getName(), annotationType.getSimpleName()));
        }
        return Optional.of(new MethodWrapper(methods.iterator().next()));
    }
}

