/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataAttributes;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.internal.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.metadata.MetadataInputDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeyIdObjectResolver;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeysDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataOutputDelegate;
import org.mule.runtime.module.extension.internal.runtime.ParameterValueResolver;

public final class MetadataMediator<T extends ComponentModel<T>> {
    protected final T component;
    private final List<ParameterModel> metadataKeyParts;
    private final MetadataKeysDelegate keysDelegate;
    private final MetadataOutputDelegate outputDelegate;
    private final MetadataInputDelegate inputDelegate;
    private final MetadataKeyIdObjectResolver keyIdObjectResolver;
    private String keyContainerName = null;

    public MetadataMediator(T componentModel) {
        this.component = componentModel;
        this.metadataKeyParts = this.getMetadataKeyParts((ComponentModel)componentModel);
        this.keysDelegate = new MetadataKeysDelegate((ComponentModel)componentModel, this.metadataKeyParts);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver((ComponentModel)this.component);
        this.outputDelegate = new MetadataOutputDelegate((ComponentModel)componentModel);
        this.inputDelegate = new MetadataInputDelegate((ComponentModel)componentModel);
        componentModel.getModelProperty(MetadataKeyIdModelProperty.class).ifPresent(keyIdMP -> {
            this.keyContainerName = keyIdMP.getParameterName();
        });
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context) {
        return this.keysDelegate.getMetadataKeys(context);
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, MetadataKey key) {
        try {
            Object resolvedKey = this.keyIdObjectResolver.resolve(key);
            return this.getMetadata(context, p -> resolvedKey, MetadataAttributes.builder().withKey(key));
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, ParameterValueResolver metadataKeyResolver) {
        return this.getMetadata(context, metadataKeyResolver, MetadataAttributes.builder());
    }

    private MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, ParameterValueResolver metadataKeyResolver, MetadataAttributes.MetadataAttributesBuilder attributesBuilder) {
        MetadataResult<Object> keyValueResult = this.getMetadataKeyObjectValue(metadataKeyResolver);
        if (!keyValueResult.isSuccess()) {
            return keyValueResult;
        }
        Object keyValue = keyValueResult.get();
        if (keyValue != null) {
            attributesBuilder.withKey(MetadataKeyBuilder.newKey((String)keyValue.toString()).build());
        }
        MetadataResult<OutputMetadataDescriptor> output = this.outputDelegate.getOutputMetadataDescriptor(context, keyValue);
        MetadataResult<InputMetadataDescriptor> input = this.inputDelegate.getInputMetadataDescriptors(context, keyValue);
        if (output.isSuccess() && input.isSuccess()) {
            MetadataAttributes metadataAttributes = this.getMetadataAttributes(attributesBuilder, this.outputDelegate, (InputMetadataDescriptor)input.get());
            ComponentModel model = this.component.getTypedModel((InputMetadataDescriptor)input.get(), (OutputMetadataDescriptor)output.get());
            return MetadataResult.success((Object)ComponentMetadataDescriptor.builder((ComponentModel)model).withAttributes(metadataAttributes).build());
        }
        ImmutableList failures = ImmutableList.builder().addAll((Iterable)output.getFailures()).addAll((Iterable)input.getFailures()).build();
        return MetadataResult.failure((Object)ComponentMetadataDescriptor.builder(this.component).build(), (List)failures);
    }

    private MetadataAttributes getMetadataAttributes(MetadataAttributes.MetadataAttributesBuilder attributesBuilder, MetadataOutputDelegate outputDelegate, InputMetadataDescriptor input) {
        outputDelegate.getCategoryName().ifPresent(arg_0 -> ((MetadataAttributes.MetadataAttributesBuilder)attributesBuilder).withCategoryName(arg_0));
        outputDelegate.getOutputResolver().ifPresent(r -> attributesBuilder.withOutputResolver(r.getResolverName()));
        outputDelegate.getOutputAttributesResolver().ifPresent(r -> attributesBuilder.withOutputAttributesResolver(r.getResolverName()));
        input.getAllParameters().entrySet().forEach(entry -> attributesBuilder.withParameterResolver((String)entry.getKey(), this.inputDelegate.getParameterResolver((String)entry.getKey()).getResolverName()));
        return attributesBuilder.build();
    }

    private MetadataResult<Object> getMetadataKeyObjectValue(ParameterValueResolver metadataKeyResolver) {
        try {
            Object keyValue = this.getContainerName().isPresent() ? metadataKeyResolver.getParameterValue(this.getContainerName().get()) : null;
            return MetadataResult.success(keyValue);
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }

    private List<ParameterModel> getMetadataKeyParts(ComponentModel componentModel) {
        return componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    private Optional<String> getContainerName() {
        return Optional.ofNullable(this.keyContainerName);
    }
}

