/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.streaming.CursorStreamProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilderUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultObjectBuilder<T>
implements ObjectBuilder<T> {
    private final Class<T> prototypeClass;
    private final Map<Field, ValueResolver<Object>> resolvers = new HashMap<Field, ValueResolver<Object>>();

    public DefaultObjectBuilder(Class<T> prototypeClass) {
        IntrospectionUtils.checkInstantiable(prototypeClass);
        this.prototypeClass = prototypeClass;
    }

    public ObjectBuilder<T> addPropertyResolver(String propertyName, ValueResolver<? extends Object> resolver) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)propertyName) ? 1 : 0) != 0, (String)"property name cannot be blank");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        Field field = IntrospectionUtils.getField(this.prototypeClass, propertyName).orElseThrow(() -> new IllegalArgumentException(String.format("Class '%s' does not contain property '%s'", this.prototypeClass.getName(), propertyName)));
        field.setAccessible(true);
        this.resolvers.put(field, resolver);
        return this;
    }

    @Override
    public boolean isDynamic() {
        return MuleExtensionUtils.hasAnyDynamic(this.resolvers.values());
    }

    @Override
    public T build(Event event) throws MuleException {
        T object = ObjectBuilderUtils.createInstance(this.prototypeClass);
        for (Map.Entry<Field, ValueResolver<Object>> entry : this.resolvers.entrySet()) {
            ReflectionUtils.setField((Field)entry.getKey(), object, (Object)this.resolve(entry.getValue(), event));
        }
        return object;
    }

    private Object resolve(ValueResolver resolver, Event event) throws MuleException {
        Object value = resolver.resolve(event);
        if (value instanceof ValueResolver) {
            value = this.resolve((ValueResolver)value, event);
        }
        if (value instanceof CursorStreamProvider) {
            value = ((CursorStreamProvider)value).openCursor();
        }
        return value;
    }
}

