/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class ExpressionValueResolver<T>
implements ValueResolver<T> {
    final AttributeEvaluator evaluator;
    private final MuleContext muleContext;
    private boolean evaluatorInitialized = false;
    private BiConsumer<AttributeEvaluator, MuleContext> evaluatorInitialiser = (evaluator, context) -> {
        MuleContext muleContext = context;
        synchronized (muleContext) {
            if (!this.evaluatorInitialized) {
                evaluator.initialize(context.getExpressionManager());
                this.evaluatorInitialiser = (e, c) -> {};
                this.evaluatorInitialized = true;
            }
        }
    };

    public ExpressionValueResolver(String expression, MuleContext muleContext) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        this.evaluator = new AttributeEvaluator(expression);
        this.muleContext = muleContext;
    }

    @Override
    public T resolve(Event event) throws MuleException {
        this.initEvaluator();
        TypedValue typedValue = this.evaluator.resolveTypedValue(event, Event.builder((Event)event));
        Object value = typedValue.getValue();
        if (ClassUtils.isInstance(ValueResolver.class, (Object)value)) {
            value = ((ValueResolver)value).resolve(event);
        }
        return (T)value;
    }

    void initEvaluator() {
        this.evaluatorInitialiser.accept(this.evaluator, this.muleContext);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }
}

