/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.function.Supplier;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.execution.ExceptionCallback;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessTemplate;
import org.mule.runtime.core.execution.MessageProcessingManager;
import org.mule.runtime.core.execution.SourceResultAdapter;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.ModuleFlowProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

class DefaultSourceCallback<T, A extends Attributes>
implements SourceCallback<T, A> {
    private SourceModel sourceModel;
    private Processor listener;
    private FlowConstruct flowConstruct;
    private ExceptionCallback exceptionCallback;
    private MessageProcessingManager messageProcessingManager;
    private Supplier<MessageProcessContext> processContextSupplier;
    private SourceCompletionHandlerFactory completionHandlerFactory;
    private CursorStreamProviderFactory cursorStreamProviderFactory;
    private boolean returnsListOfMessages = false;

    static Builder builder() {
        return new Builder();
    }

    private DefaultSourceCallback() {
    }

    public void handle(Result<T, A> result) {
        this.handle(result, this.createContext());
    }

    public void handle(Result<T, A> result, SourceCallbackContext context) {
        MessageProcessContext messageProcessContext = this.processContextSupplier.get();
        SourceResultAdapter resultAdapter = new SourceResultAdapter(result, this.cursorStreamProviderFactory, this.returnsListOfMessages);
        Message message = Message.builder().payload((Object)resultAdapter).build();
        this.messageProcessingManager.processMessage((MessageProcessTemplate)new ModuleFlowProcessingTemplate(message, this.listener, this.completionHandlerFactory.createCompletionHandler(context), messageProcessContext), messageProcessContext);
    }

    public void onSourceException(Throwable exception) {
        this.exceptionCallback.onException(exception);
    }

    public SourceCallbackContext createContext() {
        return new DefaultSourceCallbackContext(this);
    }

    static class Builder<T, A extends Attributes> {
        private DefaultSourceCallback<T, A> product = new DefaultSourceCallback();

        private Builder() {
        }

        public Builder<T, A> setSourceModel(SourceModel sourceModel) {
            ((DefaultSourceCallback)this.product).sourceModel = sourceModel;
            ((DefaultSourceCallback)this.product).returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages((ComponentModel)sourceModel);
            return this;
        }

        public Builder<T, A> setListener(Processor listener) {
            ((DefaultSourceCallback)this.product).listener = listener;
            return this;
        }

        public Builder<T, A> setFlowConstruct(FlowConstruct flowConstruct) {
            ((DefaultSourceCallback)this.product).flowConstruct = flowConstruct;
            return this;
        }

        public Builder<T, A> setExceptionCallback(ExceptionCallback exceptionCallback) {
            ((DefaultSourceCallback)this.product).exceptionCallback = exceptionCallback;
            return this;
        }

        public Builder<T, A> setProcessingManager(MessageProcessingManager processingManager) {
            ((DefaultSourceCallback)this.product).messageProcessingManager = processingManager;
            return this;
        }

        public Builder<T, A> setProcessContextSupplier(Supplier<MessageProcessContext> processContextSupplier) {
            ((DefaultSourceCallback)this.product).processContextSupplier = processContextSupplier;
            return this;
        }

        public Builder<T, A> setCompletionHandlerFactory(SourceCompletionHandlerFactory completionHandlerFactory) {
            ((DefaultSourceCallback)this.product).completionHandlerFactory = completionHandlerFactory;
            return this;
        }

        public Builder<T, A> setCursorStreamProviderFactory(CursorStreamProviderFactory cursorStreamProviderFactory) {
            ((DefaultSourceCallback)this.product).cursorStreamProviderFactory = cursorStreamProviderFactory;
            return this;
        }

        public SourceCallback<T, A> build() {
            this.checkArgument(((DefaultSourceCallback)this.product).listener, "listener");
            this.checkArgument(((DefaultSourceCallback)this.product).flowConstruct, "flowConstruct");
            this.checkArgument(((DefaultSourceCallback)this.product).exceptionCallback, "exceptionCallback");
            this.checkArgument(((DefaultSourceCallback)this.product).messageProcessingManager, "messageProcessingManager");
            this.checkArgument(((DefaultSourceCallback)this.product).processContextSupplier, "processContextSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).completionHandlerFactory, "completionHandlerSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).sourceModel, "sourceModel");
            this.checkArgument(((DefaultSourceCallback)this.product).cursorStreamProviderFactory, "cursorStreamProviderFactory");
            return this.product;
        }

        private void checkArgument(Object value, String name) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)(name + " was not set"));
        }
    }
}

