/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import com.google.common.base.Predicate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ExceptionCallback;
import org.mule.runtime.core.util.func.CheckedRunnable;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.source.NullSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.NullSourceCompletionHandler;
import org.mule.runtime.module.extension.internal.runtime.source.ReflectiveSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.reflections.ReflectionUtils;

public final class SourceAdapter
implements Startable,
Stoppable,
FlowConstructAware {
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private final Source source;
    private final Optional<ConfigurationInstance> configurationInstance;
    private final Optional<FieldSetter<Object, Object>> configurationSetter;
    private final Optional<FieldSetter<Object, Object>> connectionSetter;
    private final SourceCallbackFactory sourceCallbackFactory;
    private final ResolverSet successCallbackParameters;
    private final ResolverSet errorCallbackParameters;
    private ConnectionHandler<Object> connectionHandler;
    private FlowConstruct flowConstruct;
    @Inject
    private ConnectionManager connectionManager;
    @Inject
    private MuleContext muleContext;

    public SourceAdapter(ExtensionModel extensionModel, SourceModel sourceModel, Source source, Optional<ConfigurationInstance> configurationInstance, SourceCallbackFactory sourceCallbackFactory, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters) {
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
        this.source = source;
        this.configurationInstance = configurationInstance;
        this.sourceCallbackFactory = sourceCallbackFactory;
        this.successCallbackParameters = successCallbackParameters;
        this.errorCallbackParameters = errorCallbackParameters;
        this.configurationSetter = this.fetchField(UseConfig.class);
        this.connectionSetter = this.fetchField(Connection.class);
    }

    private SourceCallback createSourceCallback() {
        return this.sourceCallbackFactory.createSourceCallback(this.createCompletionHandlerFactory());
    }

    private SourceCompletionHandlerFactory createCompletionHandlerFactory() {
        return this.sourceModel.getModelProperty(SourceCallbackModelProperty.class).map(this::doCreateCompletionHandler).orElse(context -> new NullSourceCompletionHandler());
    }

    private SourceCompletionHandlerFactory doCreateCompletionHandler(SourceCallbackModelProperty modelProperty) {
        SourceCallbackExecutor onSuccessExecutor = this.getMethodExecutor(modelProperty.getOnSuccessMethod());
        SourceCallbackExecutor onErrorExecutor = this.getMethodExecutor(modelProperty.getOnErrorMethod());
        return context -> new DefaultSourceCompletionHandler(onSuccessExecutor, onErrorExecutor, context);
    }

    private SourceCallbackExecutor getMethodExecutor(Optional<Method> method) {
        return method.map(m -> new ReflectiveSourceCallbackExecutor(this.extensionModel, this.configurationInstance, this.sourceModel, this.source, (Method)m, this.muleContext)).orElse(new NullSourceCallbackExecutor());
    }

    public void start() throws MuleException {
        if (this.source instanceof FlowConstructAware) {
            ((FlowConstructAware)this.source).setFlowConstruct(this.flowConstruct);
        }
        try {
            this.setConfiguration(this.configurationInstance);
            this.setConnection();
            this.muleContext.getInjector().inject((Object)this.source);
            this.source.onStart(this.createSourceCallback());
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public void stop() throws MuleException {
        try {
            this.source.onStop();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
        finally {
            this.releaseConnection();
        }
    }

    private void setConfiguration(Optional<ConfigurationInstance> configuration) {
        if (this.configurationSetter.isPresent() && configuration.isPresent()) {
            this.configurationSetter.get().set(this.source, configuration.get().getValue());
        }
    }

    private void setConnection() {
        if (this.connectionSetter.isPresent() && this.configurationInstance.isPresent()) {
            try {
                this.connectionHandler = this.connectionManager.getConnection(this.configurationInstance.get().getValue());
                this.connectionSetter.get().set(this.source, this.connectionHandler.getConnection());
            }
            catch (ConnectionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not obtain connection for message source '%s' on flow '%s'", this.getName(), this.flowConstruct.getName())), (Throwable)e);
            }
        }
    }

    private void releaseConnection() {
        if (this.connectionHandler != null) {
            try {
                this.connectionHandler.release();
            }
            finally {
                this.connectionHandler = null;
            }
        }
    }

    private <T> Optional<FieldSetter<Object, T>> fetchField(Class<? extends Annotation> annotation) {
        Set fields = ReflectionUtils.getAllFields(this.source.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(annotation)});
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return Optional.empty();
        }
        if (fields.size() > 1) {
            throw new IllegalModelDefinitionException(String.format("Message Source defined on class '%s' has more than one field annotated with '@%s'. Only one field in the class can bare such annotation", this.source.getClass().getName(), annotation.getClass().getSimpleName()));
        }
        return Optional.of(new FieldSetter((Field)fields.iterator().next()));
    }

    public String getName() {
        return IntrospectionUtils.getSourceName(this.source.getClass());
    }

    public Source getDelegate() {
        return this.source;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public class DefaultSourceCompletionHandler
    implements SourceCompletionHandler {
        private final SourceCallbackExecutor onSuccessExecutor;
        private final SourceCallbackExecutor onErrorExecutor;
        private final SourceCallbackContext context;

        public DefaultSourceCompletionHandler(SourceCallbackExecutor onSuccessExecutor, SourceCallbackExecutor onErrorExecutor, SourceCallbackContext context) {
            this.onSuccessExecutor = onSuccessExecutor;
            this.onErrorExecutor = onErrorExecutor;
            this.context = context;
        }

        @Override
        public void onCompletion(Event event, Map<String, Object> parameters, ExceptionCallback<Throwable> exceptionCallback) {
            this.safely(() -> this.onSuccessExecutor.execute(event, parameters, this.context), exceptionCallback);
        }

        @Override
        public void onFailure(MessagingException exception, Map<String, Object> parameters) {
            this.safely(() -> this.onErrorExecutor.execute(exception.getEvent(), parameters, this.context), callbackException -> {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Found exception trying to handle error from source '%s'", SourceAdapter.this.sourceModel.getName())), callbackException);
            });
        }

        private void safely(CheckedRunnable task, ExceptionCallback exceptionCallback) {
            try {
                task.run();
            }
            catch (Throwable e) {
                exceptionCallback.onException(e);
            }
        }

        @Override
        public Map<String, Object> createResponseParameters(Event event) {
            try {
                ResolverSetResult parameters = SourceAdapter.this.successCallbackParameters.resolve(event);
                return parameters.asMap();
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        @Override
        public Map<String, Object> createFailureResponseParameters(Event event) {
            try {
                ResolverSetResult parameters = SourceAdapter.this.errorCallbackParameters.resolve(event);
                return parameters.asMap();
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }
}

