/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.policy;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.listener.builder.HttpListenerErrorResponseBuilder;
import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.api.listener.builder.HttpListenerSuccessResponseBuilder;
import org.mule.extension.http.api.policy.HttpPolicyResponseAttributes;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.service.http.api.domain.ParameterMap;

public class HttpListenerPolicyParametersTransformer
implements SourcePolicyParametersTransformer {
    public boolean supports(ComponentIdentifier componentIdentifier) {
        return componentIdentifier.equals(ComponentIdentifier.buildFromStringRepresentation((String)"http:listener"));
    }

    public Message fromSuccessResponseParametersToMessage(Map<String, Object> parameters) {
        HttpListenerResponseBuilder responseBuilder = (HttpListenerResponseBuilder)parameters.get("response");
        return this.responseParametersToMessage(responseBuilder, 200);
    }

    private Message responseParametersToMessage(HttpListenerResponseBuilder responseBuilder, int defaultStatusCode) {
        ParameterMap headers = new ParameterMap(responseBuilder.getHeaders());
        Message.PayloadBuilder builder = Message.builder();
        TypedValue<Object> body = responseBuilder.getBody();
        Message.Builder messageBuilder = body.getValue() == null ? builder.nullPayload() : builder.payload(body.getValue()).mediaType(body.getDataType().getMediaType());
        int statusCode = responseBuilder.getStatusCode() == null ? defaultStatusCode : responseBuilder.getStatusCode();
        return messageBuilder.attributes((Object)new HttpResponseAttributes(statusCode, responseBuilder.getReasonPhrase(), headers)).build();
    }

    public Message fromFailureResponseParametersToMessage(Map<String, Object> parameters) {
        HttpListenerResponseBuilder responseBuilder = (HttpListenerResponseBuilder)parameters.get("errorResponse");
        return this.responseParametersToMessage(responseBuilder, 500);
    }

    public Map<String, Object> fromMessageToSuccessResponseParameters(Message message) {
        return this.messageToResponseParameters(new HttpListenerSuccessResponseBuilder(), "response", message);
    }

    public Map<String, Object> fromMessageToErrorResponseParameters(Message message) {
        return this.messageToResponseParameters(new HttpListenerErrorResponseBuilder(), "errorResponse", message);
    }

    private Map<String, Object> messageToResponseParameters(HttpListenerResponseBuilder httpListenerResponseBuilder, String responseBuilderParameterName, Message message) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)responseBuilderParameterName, (Object)httpListenerResponseBuilder);
        if (message.getAttributes().getValue() instanceof HttpResponseAttributes) {
            HttpResponseAttributes httpResponseAttributes = (HttpResponseAttributes)((Object)message.getAttributes().getValue());
            httpListenerResponseBuilder.setBody((TypedValue<Object>)message.getPayload());
            httpListenerResponseBuilder.setHeaders((Map<String, String>)httpResponseAttributes.getHeaders());
            httpListenerResponseBuilder.setStatusCode(httpResponseAttributes.getStatusCode());
            httpListenerResponseBuilder.setReasonPhrase(httpResponseAttributes.getReasonPhrase());
            return mapBuilder.build();
        }
        if (message.getAttributes().getValue() instanceof HttpPolicyResponseAttributes) {
            HttpPolicyResponseAttributes httpResponseAttributes = (HttpPolicyResponseAttributes)message.getAttributes().getValue();
            httpListenerResponseBuilder.setBody((TypedValue<Object>)message.getPayload());
            httpListenerResponseBuilder.setHeaders(httpResponseAttributes.getHeaders());
            httpListenerResponseBuilder.setStatusCode(httpResponseAttributes.getStatusCode());
            httpListenerResponseBuilder.setReasonPhrase(httpResponseAttributes.getReasonPhrase());
            return mapBuilder.build();
        }
        return mapBuilder.build();
    }
}

