/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.extension.http.api.HttpMessageBuilder;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public class HttpRequesterRequestBuilder
extends HttpMessageBuilder {
    @Parameter
    @Content(primary=true)
    private TypedValue<Object> body;
    @Parameter
    @Optional
    @Content
    protected Map<String, String> headers = new HashMap<String, String>();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="URI Parameters")
    private Map<String, String> uriParams = new HashMap<String, String>();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="Query Parameters")
    private Map<String, String> queryParams = new HashMap<String, String>();

    @Override
    public TypedValue<Object> getBody() {
        return this.body;
    }

    @Override
    public void setBody(TypedValue<Object> body) {
        this.body = body;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String replaceUriParams(String path) {
        for (String uriParamName : this.uriParams.keySet()) {
            String uriParamValue = this.uriParams.get(uriParamName);
            if (uriParamValue == null) {
                throw new NullPointerException(String.format("Expression {%s} evaluated to null.", uriParamName));
            }
            path = path.replaceAll(String.format("\\{%s\\}", uriParamName), uriParamValue);
        }
        return path;
    }

    public Map<String, String> getQueryParams() {
        return Collections.unmodifiableMap(this.queryParams);
    }

    public Map<String, String> getUriParams() {
        return Collections.unmodifiableMap(this.uriParams);
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setUriParams(Map<String, String> uriParams) {
        this.uriParams = uriParams;
    }
}

