/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.internal.HttpStreamingType;
import org.mule.extension.http.internal.listener.HttpResponseContext;
import org.mule.extension.http.internal.listener.HttpResponseFactory;
import org.mule.runtime.core.api.TransformationService;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.api.server.async.ResponseStatusCallback;

public class HttpListenerResponseSender {
    private final HttpResponseFactory responseFactory;

    public HttpListenerResponseSender(HttpResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    public HttpListenerResponseSender(TransformationService transformationService) {
        this.responseFactory = new HttpResponseFactory(HttpStreamingType.NEVER, transformationService);
    }

    public void sendResponse(HttpResponseContext context, HttpListenerResponseBuilder response) throws Exception {
        HttpResponse httpResponse = this.buildResponse(response, context.isSupportStreaming());
        HttpResponseReadyCallback responseCallback = context.getResponseCallback();
        responseCallback.responseReady(httpResponse, this.getResponseFailureCallback(responseCallback));
    }

    protected HttpResponse buildResponse(HttpListenerResponseBuilder listenerResponseBuilder, boolean supportStreaming) throws Exception {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        return this.doBuildResponse(responseBuilder, listenerResponseBuilder, supportStreaming);
    }

    protected HttpResponse doBuildResponse(HttpResponseBuilder responseBuilder, HttpListenerResponseBuilder listenerResponseBuilder, boolean supportsStreaming) throws Exception {
        return this.responseFactory.create(responseBuilder, listenerResponseBuilder, supportsStreaming);
    }

    private ResponseStatusCallback getResponseFailureCallback(final HttpResponseReadyCallback responseReadyCallback) {
        return new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
                responseReadyCallback.responseReady(HttpListenerResponseSender.this.buildErrorResponse(), (ResponseStatusCallback)this);
            }

            public void responseSendSuccessfully() {
            }
        };
    }

    protected HttpResponse buildErrorResponse() {
        HttpResponseBuilder errorResponseBuilder = HttpResponse.builder();
        HttpResponse errorResponse = errorResponseBuilder.setStatusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).setReasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
        return errorResponse;
    }
}

