/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.security.cert.Certificate;
import java.util.Collection;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.internal.listener.ListenerPath;
import org.mule.service.http.api.domain.ParameterMap;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.request.ClientConnection;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;

public class HttpRequestAttributesBuilder {
    private HttpRequestContext requestContext;
    private ListenerPath listenerPath;

    public HttpRequestAttributesBuilder setRequestContext(HttpRequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public HttpRequestAttributesBuilder setListenerPath(ListenerPath listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public HttpRequestAttributes build() {
        String listenerPath = this.listenerPath.getResolvedPath();
        HttpRequest request = this.requestContext.getRequest();
        String version = request.getProtocol().asString();
        String scheme = this.requestContext.getScheme();
        String method = request.getMethod();
        String uri = request.getUri();
        String path = HttpEncoderDecoderUtils.extractPath((String)uri);
        String queryString = HttpEncoderDecoderUtils.extractQueryParams((String)uri);
        ParameterMap queryParams = HttpEncoderDecoderUtils.decodeQueryString((String)queryString);
        ParameterMap uriParams = HttpEncoderDecoderUtils.decodeUriParams((String)listenerPath, (String)path);
        ClientConnection clientConnection = this.requestContext.getClientConnection();
        String remoteHostAddress = clientConnection.getRemoteHostAddress().toString();
        Certificate clientCertificate = clientConnection.getClientCertificate();
        String relativePath = this.listenerPath.getRelativePath(path);
        Collection headerNames = request.getHeaderNames();
        ParameterMap headers = new ParameterMap();
        for (String headerName : headerNames) {
            headers.put(headerName, request.getHeaderValues(headerName));
        }
        return new HttpRequestAttributes(headers, listenerPath, relativePath, version, scheme, method, path, uri, queryString, queryParams, uriParams, remoteHostAddress, clientCertificate);
    }
}

