/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.error.HttpMessageParsingException;
import org.mule.extension.http.internal.listener.HttpRequestAttributesBuilder;
import org.mule.extension.http.internal.listener.ListenerPath;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.message.DefaultMultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.service.http.api.HttpHeaders;
import org.mule.service.http.api.domain.entity.EmptyHttpEntity;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestToResult {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestToResult.class);

    public static Result<Object, HttpRequestAttributes> transform(HttpRequestContext requestContext, Charset encoding, Boolean parseRequest, ListenerPath listenerPath) throws HttpMessageParsingException {
        HttpRequest request = requestContext.getRequest();
        MediaType mediaType = HttpRequestToResult.getMediaType(request.getHeaderValueIgnoreCase("Content-Type"), encoding);
        InputStream payload = null;
        if (parseRequest.booleanValue()) {
            HttpEntity entity = request.getEntity();
            if (entity != null && !(entity instanceof EmptyHttpEntity)) {
                if (entity instanceof MultipartHttpEntity) {
                    try {
                        payload = HttpRequestToResult.multiPartPayloadForAttachments((MultipartHttpEntity)entity);
                    }
                    catch (IOException e) {
                        throw new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)"Unable to process multipart request"), e);
                    }
                } else if (mediaType != null) {
                    if (mediaType.matches(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED)) {
                        try {
                            payload = HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)IOUtils.toString((InputStream)((InputStreamHttpEntity)entity).getInputStream()), (Charset)((Charset)mediaType.getCharset().get()));
                        }
                        catch (IllegalArgumentException e) {
                            throw new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)"Cannot decode %s payload", (Object[])new Object[]{HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.getSubType()}), e);
                        }
                    } else if (entity instanceof InputStreamHttpEntity) {
                        payload = ((InputStreamHttpEntity)entity).getInputStream();
                    }
                } else if (entity instanceof InputStreamHttpEntity) {
                    payload = ((InputStreamHttpEntity)entity).getInputStream();
                }
            }
        } else {
            InputStreamHttpEntity inputStreamEntity = request.getInputStreamEntity();
            if (inputStreamEntity != null) {
                payload = inputStreamEntity.getInputStream();
            }
        }
        HttpRequestAttributes attributes = new HttpRequestAttributesBuilder().setRequestContext(requestContext).setListenerPath(listenerPath).build();
        return Result.builder().output((Object)payload).mediaType(mediaType).attributes((Object)attributes).build();
    }

    public static MultiPartPayload multiPartPayloadForAttachments(MultipartHttpEntity entity) throws IOException {
        return HttpRequestToResult.multiPartPayloadForAttachments(entity.getParts());
    }

    private static MultiPartPayload multiPartPayloadForAttachments(Collection<HttpPart> httpParts) throws IOException {
        ArrayList<Message> parts = new ArrayList<Message>();
        int partNumber = 1;
        for (HttpPart httpPart : httpParts) {
            HashMap headers = new HashMap();
            for (String headerName : httpPart.getHeaderNames()) {
                if (!headers.containsKey(headerName)) {
                    headers.put(headerName, new LinkedList());
                }
                ((LinkedList)headers.get(headerName)).addAll(httpPart.getHeaders(headerName));
            }
            parts.add(Message.builder().payload((Object)httpPart.getInputStream()).mediaType(MediaType.parse((String)httpPart.getContentType())).attributes((Object)new PartAttributes(httpPart.getName() != null ? httpPart.getName() : "part_" + partNumber, httpPart.getFileName(), httpPart.getSize(), headers)).build());
            ++partNumber;
        }
        return new DefaultMultiPartPayload(parts);
    }

    public static MediaType getMediaType(String contentTypeValue, Charset defaultCharset) {
        MediaType mediaType = MediaType.ANY;
        if (contentTypeValue != null) {
            try {
                mediaType = MediaType.parse((String)contentTypeValue);
            }
            catch (IllegalArgumentException e) {
                if (Boolean.parseBoolean(System.getProperty("mule.strictContentType"))) {
                    throw e;
                }
                logger.warn(String.format("%s when parsing Content-Type '%s': %s", e.getClass().getName(), contentTypeValue, e.getMessage()));
                logger.warn(String.format("Using default encoding: %s", Charset.defaultCharset().name()));
            }
        }
        if (!mediaType.getCharset().isPresent()) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }
}

