/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.mule.extension.http.internal.multipart.HttpMimeMultipart;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.util.IOUtils;
import org.mule.service.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.api.domain.entity.multipart.MultipartHttpEntity;

public class HttpMultipartEncoder {
    private static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";

    public static MimeMultipart createMultpartContent(MultipartHttpEntity body, String contentType) {
        String contentTypeSubType = HttpMultipartEncoder.getContentTypeSubType(contentType);
        HttpMimeMultipart mimeMultipartContent = new HttpMimeMultipart(contentType, contentTypeSubType);
        Collection parts = body.getParts();
        for (HttpPart part : parts) {
            InternetHeaders internetHeaders = new InternetHeaders();
            for (String headerName : part.getHeaderNames()) {
                Collection headerValues = part.getHeaders(headerName);
                for (String headerValue : headerValues) {
                    internetHeaders.addHeader(headerName, headerValue);
                }
            }
            if (internetHeaders.getHeader("Content-Disposition") == null) {
                String partType = contentTypeSubType.equals(FORM_DATA) ? FORM_DATA : ATTACHMENT;
                internetHeaders.addHeader("Content-Disposition", HttpMultipartEncoder.getContentDisposition(part, partType));
            }
            if (internetHeaders.getHeader("Content-Type") == null && part.getContentType() != null) {
                internetHeaders.addHeader("Content-Type", part.getContentType());
            }
            try {
                byte[] partContent = IOUtils.toByteArray((InputStream)part.getInputStream());
                mimeMultipartContent.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders, partContent));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return mimeMultipartContent;
    }

    private static String getContentTypeSubType(String contentType) {
        try {
            ContentType contentTypeValue = new ContentType(contentType);
            return contentTypeValue.getSubType();
        }
        catch (ParseException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private static String getContentDisposition(HttpPart part, String partType) {
        StringBuilder builder = new StringBuilder();
        builder.append(partType);
        builder.append("; name=\"");
        builder.append(part.getName());
        builder.append("\"");
        if (part.getFileName() != null) {
            builder.append("; filename=\"");
            builder.append(part.getFileName());
            builder.append("\"");
        }
        return builder.toString();
    }

    public static byte[] createMultipartContent(MultipartHttpEntity multipartEntity, String contentType) throws IOException, MessagingException {
        MimeMultipart mimeMultipartContent = HttpMultipartEncoder.createMultpartContent(multipartEntity, contentType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        mimeMultipartContent.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Collection<HttpPart> createFrom(MultiPartPayload multiPartPayload, Transformer objectToByteArray) {
        return multiPartPayload.getParts().stream().map(message -> {
            PartAttributes partAttributes = (PartAttributes)message.getAttributes().getValue();
            TypedValue payload = message.getPayload();
            String name = partAttributes.getName();
            try {
                byte[] data = (byte[])objectToByteArray.transform(payload.getValue());
                String fileName = partAttributes.getFileName();
                String contentType = payload.getDataType().getMediaType().toRfcString();
                int size = Math.toIntExact(partAttributes.getSize());
                if (fileName != null) {
                    return new HttpPart(name, fileName, data, contentType, size);
                }
                return new HttpPart(name, data, contentType, size);
            }
            catch (TransformerException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create HTTP part %s", name), (Object[])new Object[]{e}));
            }
        }).collect(Collectors.toList());
    }
}

