/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.SuccessStatusCodeValidator;
import org.mule.extension.http.internal.HttpRequestMetadataResolver;
import org.mule.extension.http.internal.HttpStreamingType;
import org.mule.extension.http.internal.request.ConfigurationOverrides;
import org.mule.extension.http.internal.request.HttpRequester;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.HttpSendBodyMode;
import org.mule.extension.http.internal.request.OutputSettings;
import org.mule.extension.http.internal.request.RequestErrorTypeProvider;
import org.mule.extension.http.internal.request.ResponseValidationSettings;
import org.mule.extension.http.internal.request.UriSettings;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;

public class HttpRequestOperations
implements Initialisable,
Disposable {
    private static final int WAIT_FOR_EVER = Integer.MAX_VALUE;
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    @Summary(value="Executes a HTTP Request")
    @OutputResolver(output=HttpRequestMetadataResolver.class)
    @Throws(value={RequestErrorTypeProvider.class})
    @Streaming
    public void request(@Placement(order=1) @ParameterGroup(name="URI Settings") UriSettings uriSettings, @Placement(order=2) @Optional(defaultValue="GET") String method, @ParameterGroup(name="Configuration Overrides") ConfigurationOverrides overrides, @Placement(order=3) @ParameterGroup(name="Request Settings") HttpRequesterRequestBuilder requestBuilder, @Placement(order=4) @ParameterGroup(name="Response Validation Settings") ResponseValidationSettings responseValidationSettings, @ParameterGroup(name="Other Settings") OutputSettings outputSettings, @Connection HttpExtensionClient client, @Config HttpRequesterConfig config, CompletionCallback<Object, HttpResponseAttributes> callback) {
        try {
            String resolvedUri;
            HttpRequesterRequestBuilder resolvedBuilder;
            HttpRequesterRequestBuilder httpRequesterRequestBuilder = resolvedBuilder = requestBuilder != null ? requestBuilder : new HttpRequesterRequestBuilder();
            if (uriSettings.getUrl() == null) {
                UriParameters uriParameters = client.getDefaultUriParameters();
                String resolvedBasePath = config.getBasePath();
                String resolvedPath = resolvedBuilder.replaceUriParams(this.buildPath(resolvedBasePath, uriSettings.getPath()));
                resolvedUri = this.resolveUri(uriParameters.getScheme(), uriParameters.getHost(), uriParameters.getPort(), resolvedPath);
            } else {
                resolvedUri = resolvedBuilder.replaceUriParams(uriSettings.getUrl());
            }
            Boolean resolvedFollowRedirects = this.resolveIfNecessary(overrides.getFollowRedirects(), config.getFollowRedirects());
            HttpStreamingType resolvedStreamingMode = this.resolveIfNecessary(overrides.getRequestStreamingMode(), config.getRequestStreamingMode());
            HttpSendBodyMode resolvedSendBody = this.resolveIfNecessary(overrides.getSendBodyMode(), config.getSendBodyMode());
            Boolean resolvedParseResponse = this.resolveIfNecessary(overrides.getParseResponse(), config.getParseResponse());
            Integer resolvedTimeout = this.resolveResponseTimeout(config, overrides.getResponseTimeout());
            ResponseValidator responseValidator = responseValidationSettings.getResponseValidator();
            responseValidator = responseValidator != null ? responseValidator : new SuccessStatusCodeValidator("0..399");
            HttpRequester requester = new HttpRequester.Builder().setUri(resolvedUri).setMethod(method).setFollowRedirects(resolvedFollowRedirects).setRequestStreamingMode(resolvedStreamingMode).setSendBodyMode(resolvedSendBody).setAuthentication(client.getDefaultAuthentication()).setParseResponse(resolvedParseResponse).setResponseTimeout(resolvedTimeout).setResponseValidator(responseValidator).setConfig(config).setTransformationService(this.muleContext.getTransformationService()).setScheduler(this.scheduler).build();
            requester.doRequest(client, resolvedBuilder, true, this.muleContext, callback);
        }
        catch (Exception e) {
            callback.error(e);
        }
    }

    private <T> T resolveIfNecessary(T value, T configValue) {
        return value != null ? value : configValue;
    }

    private String resolveUri(HttpConstants.Protocols scheme, String host, Integer port, String path) {
        return String.format("%s://%s:%s%s", scheme.getScheme(), host, port, HttpEncoderDecoderUtils.encodeSpaces((String)path));
    }

    private int resolveResponseTimeout(HttpRequesterConfig config, Integer responseTimeout) {
        if (responseTimeout == null && config.getResponseTimeout() != null) {
            responseTimeout = config.getResponseTimeout();
        }
        if (this.muleContext.getConfiguration().isDisableTimeouts()) {
            return Integer.MAX_VALUE;
        }
        return responseTimeout != null ? responseTimeout.intValue() : this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected String buildPath(String basePath, String path) {
        String resolvedBasePath = basePath;
        String resolvedRequestPath = path;
        if (!resolvedBasePath.startsWith("/")) {
            resolvedBasePath = "/" + resolvedBasePath;
        }
        if (resolvedBasePath.endsWith("/") && resolvedRequestPath.startsWith("/")) {
            resolvedBasePath = resolvedBasePath.substring(0, resolvedBasePath.length() - 1);
        }
        if (!(resolvedBasePath.endsWith("/") || resolvedRequestPath.startsWith("/") || resolvedRequestPath.isEmpty())) {
            resolvedBasePath = resolvedBasePath + "/";
        }
        return resolvedBasePath + resolvedRequestPath;
    }

    public void initialise() throws InitialisationException {
        this.scheduler = this.schedulerService.ioScheduler();
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }
}

