/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpMessageParsingException;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.extension.http.internal.request.builder.HttpResponseAttributesBuilder;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.message.DefaultMultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.service.http.api.HttpHeaders;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class HttpResponseToResult {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseToResult.class);
    private static final String MULTI_PART_PREFIX = "multipart/";
    private final Boolean parseResponse;
    private final HttpRequesterCookieConfig config;
    private final MuleContext muleContext;

    public HttpResponseToResult(HttpRequesterCookieConfig config, Boolean parseResponse, MuleContext muleContext) {
        this.config = config;
        this.parseResponse = parseResponse;
        this.muleContext = muleContext;
    }

    public Publisher<Result<Object, HttpResponseAttributes>> convert(MediaType mediaType, HttpResponse response, String uri, Scheduler scheduler) throws HttpMessageParsingException {
        String responseContentType = response.getHeaderValueIgnoreCase("Content-Type");
        if (StringUtils.isEmpty((String)responseContentType) && !MediaType.ANY.matches(mediaType)) {
            responseContentType = mediaType.toRfcString();
        }
        String finalResponseContentType = responseContentType;
        InputStream responseInputStream = ((InputStreamHttpEntity)response.getEntity()).getInputStream();
        Charset encoding = (Charset)HttpResponseToResult.getMediaType(responseContentType, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext)).getCharset().get();
        Mono payload = Mono.just((Object)responseInputStream);
        if (responseContentType != null && this.parseResponse.booleanValue()) {
            if (responseContentType.startsWith(MULTI_PART_PREFIX)) {
                payload = Mono.defer(() -> {
                    try {
                        return Mono.just((Object)HttpResponseToResult.multiPartPayloadForAttachments(finalResponseContentType, responseInputStream));
                    }
                    catch (IOException e) {
                        return Mono.error((Throwable)((Object)new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)"Unable to process multipart response"), e)));
                    }
                }).subscribeOn(Schedulers.fromExecutorService((ExecutorService)scheduler));
            } else if (responseContentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())) {
                payload = Mono.defer(() -> Mono.just((Object)HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)IOUtils.toString((InputStream)responseInputStream), (Charset)encoding))).subscribeOn(Schedulers.fromExecutorService((ExecutorService)scheduler));
            }
        }
        if (this.config.isEnableCookies()) {
            this.processCookies(response, uri);
        }
        HttpResponseAttributes responseAttributes = this.createAttributes(response);
        mediaType = DataType.builder().mediaType(mediaType).charset(encoding).build().getMediaType();
        Result.Builder builder = Result.builder();
        if (StringUtils.isEmpty((String)responseContentType)) {
            builder.mediaType(mediaType);
        } else {
            builder.mediaType(MediaType.parse((String)responseContentType));
        }
        builder.attributes((Object)responseAttributes);
        return payload.map(p -> builder.output(p).build());
    }

    private static MultiPartPayload multiPartPayloadForAttachments(String responseContentType, InputStream responseInputStream) throws IOException {
        return HttpResponseToResult.multiPartPayloadForAttachments(HttpResponseToResult.parseMultipartContent(responseInputStream, responseContentType));
    }

    private static MultiPartPayload multiPartPayloadForAttachments(Collection<HttpPart> httpParts) throws IOException {
        ArrayList<Message> parts = new ArrayList<Message>();
        int partNumber = 1;
        for (HttpPart httpPart : httpParts) {
            HashMap headers = new HashMap();
            for (String headerName : httpPart.getHeaderNames()) {
                if (!headers.containsKey(headerName)) {
                    headers.put(headerName, new LinkedList());
                }
                ((LinkedList)headers.get(headerName)).addAll(httpPart.getHeaders(headerName));
            }
            parts.add(Message.builder().payload((Object)httpPart.getInputStream()).mediaType(MediaType.parse((String)httpPart.getContentType())).attributes((Object)new PartAttributes(httpPart.getName() != null ? httpPart.getName() : "part_" + partNumber, httpPart.getFileName(), httpPart.getSize(), headers)).build());
            ++partNumber;
        }
        return new DefaultMultiPartPayload(parts);
    }

    public static Collection<HttpPart> parseMultipartContent(InputStream content, String contentType) throws IOException {
        MimeMultipart mimeMultipart = null;
        ArrayList parts = Lists.newArrayList();
        try {
            mimeMultipart = new MimeMultipart((DataSource)new ByteArrayDataSource(content, contentType));
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        try {
            int partCount = mimeMultipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                String contentDisposition;
                String filename;
                BodyPart part = mimeMultipart.getBodyPart(i);
                String partName = filename = part.getFileName();
                String[] contentDispositions = part.getHeader("Content-Disposition");
                if (contentDispositions != null && (contentDisposition = contentDispositions[0]).contains("name")) {
                    partName = contentDisposition.substring(contentDisposition.indexOf("name") + "name".length() + 2);
                    partName = partName.substring(0, partName.indexOf("\""));
                }
                HttpPart httpPart = new HttpPart(partName, filename, IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), part.getSize());
                Enumeration headers = part.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    httpPart.addHeader(header.getName(), header.getValue());
                }
                parts.add(httpPart);
            }
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        return parts;
    }

    private HttpResponseAttributes createAttributes(HttpResponse response) {
        return new HttpResponseAttributesBuilder().setResponse(response).build();
    }

    private void processCookies(HttpResponse response, String uri) {
        Collection setCookieHeader = response.getHeaderValuesIgnoreCase("Set-Cookie");
        Collection setCookie2Header = response.getHeaderValuesIgnoreCase("Set-Cookie2");
        HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
        if (setCookieHeader != null) {
            cookieHeaders.put("Set-Cookie", new ArrayList(setCookieHeader));
        }
        if (setCookie2Header != null) {
            cookieHeaders.put("Set-Cookie2", new ArrayList(setCookie2Header));
        }
        try {
            this.config.getCookieManager().put(URI.create(uri), cookieHeaders);
        }
        catch (IOException e) {
            logger.warn("Error storing cookies for URI " + uri, (Throwable)e);
        }
    }

    private static MediaType getMediaType(String contentTypeValue, Charset defaultCharset) {
        MediaType mediaType = MediaType.ANY;
        if (contentTypeValue != null) {
            try {
                mediaType = MediaType.parse((String)contentTypeValue);
            }
            catch (IllegalArgumentException e) {
                if (Boolean.parseBoolean(System.getProperty("mule.strictContentType"))) {
                    throw e;
                }
                logger.warn(String.format("%s when parsing Content-Type '%s': %s", e.getClass().getName(), contentTypeValue, e.getMessage()));
                logger.warn(String.format("Using default encoding: %s", Charset.defaultCharset().name()));
            }
        }
        if (!mediaType.getCharset().isPresent()) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }
}

