/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.connection;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.lang.RandomStringUtils;
import org.mule.extensions.jms.api.config.AckMode;
import org.mule.extensions.jms.api.connection.JmsSession;
import org.mule.extensions.jms.api.destination.ConsumerType;
import org.mule.extensions.jms.api.exception.JmsAckException;
import org.mule.extensions.jms.internal.consume.JmsMessageConsumer;
import org.mule.extensions.jms.internal.publish.JmsMessageProducer;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsConnection
implements Stoppable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnection.class);
    private final JmsSupport jmsSupport;
    private final Connection connection;
    private final Map<String, Message> pendingAckSessions = new HashMap<String, Message>();
    private final List<JmsMessageConsumer> createdConsumers = new LinkedList<JmsMessageConsumer>();
    private final List<JmsMessageProducer> createdProducers = new LinkedList<JmsMessageProducer>();
    private final List<JmsSession> createdSessions = new LinkedList<JmsSession>();

    public JmsConnection(JmsSupport jmsSupport, Connection connection) {
        this.jmsSupport = jmsSupport;
        this.connection = connection;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    public Connection get() {
        return this.connection;
    }

    public JmsSession createSession(AckMode ackMode, boolean isTopic) throws JMSException {
        JmsSession wrapper;
        Session session = this.jmsSupport.createSession(this.connection, isTopic, ackMode.equals((Object)AckMode.TRANSACTED), ackMode.getAckMode());
        if (ackMode.equals((Object)AckMode.MANUAL)) {
            String ackId = RandomStringUtils.randomAlphanumeric((int)16);
            this.pendingAckSessions.put(ackId, null);
            wrapper = new JmsSession(session, ackId);
        } else {
            wrapper = new JmsSession(session);
        }
        this.createdSessions.add(wrapper);
        return wrapper;
    }

    public JmsMessageConsumer createConsumer(Session session, Destination jmsDestination, String selector, ConsumerType consumerType) throws JMSException {
        JmsMessageConsumer consumer = new JmsMessageConsumer(this.jmsSupport.createConsumer(session, jmsDestination, selector, consumerType));
        this.createdConsumers.add(consumer);
        return consumer;
    }

    public JmsMessageProducer createProducer(Session session, Destination jmsDestination, boolean isTopic) throws JMSException {
        MessageProducer producer = this.jmsSupport.createProducer(session, jmsDestination, isTopic);
        JmsMessageProducer wrapper = new JmsMessageProducer(this.jmsSupport, producer, isTopic);
        this.createdProducers.add(wrapper);
        return wrapper;
    }

    public void registerMessageForAck(String ackId, Message message) {
        Preconditions.checkArgument((boolean)this.pendingAckSessions.containsKey(ackId), (String)String.format("Ack pending Messages can only be registered for Sessions created with this Connection, but AckId [%s] was never declared", ackId));
        this.pendingAckSessions.put(ackId, message);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Registered Message for Session AckId [%s]", ackId));
        }
    }

    public void doAck(String ackId) throws JMSException {
        Message message = this.pendingAckSessions.get(ackId);
        if (message == null) {
            throw new JmsAckException(String.format("No pending acknowledgement with ackId [%s] exists in this Connection", ackId));
        }
        message.acknowledge();
    }

    public void stop() throws MuleException {
        block5: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stopping JMS Connection: " + this.connection);
            }
            try {
                this.connection.stop();
            }
            catch (IllegalStateException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignoring Connection state exception - assuming already closed: ", (Throwable)ex);
                }
            }
            catch (JMSException ex) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Could not stop JMS Connection - assuming this method has been called in a Java EE web or EJB application: ", (Throwable)ex);
            }
        }
    }

    public void dispose() {
        block5: {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing JMS Connection: " + this.connection);
                }
                this.releaseResources();
                this.connection.close();
                this.pendingAckSessions.clear();
            }
            catch (IllegalStateException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignoring Connection state exception - assuming already closed: ", (Throwable)ex);
                }
            }
            catch (JMSException ex) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Could not close JMS Connection : ", (Throwable)ex);
            }
        }
    }

    public void releaseResources() {
        this.closeConsumers();
        this.closeProducers();
        this.closeSessions();
    }

    private void closeSessions() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing Sessions");
        }
        List closed = this.createdSessions.stream().filter(session -> !session.getAckId().isPresent() || this.pendingAckSessions.get(session.getAckId().get()) == null).peek(this::closeQuietly).collect(Collectors.toList());
        this.createdSessions.removeAll(closed);
    }

    private void closeConsumers() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing Consumers");
        }
        this.createdConsumers.forEach(this::closeQuietly);
        this.createdConsumers.clear();
    }

    private void closeProducers() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing Producers");
        }
        this.createdProducers.forEach(this::closeQuietly);
        this.createdProducers.clear();
    }

    private void closeQuietly(AutoCloseable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close jms connection resource: ", (Throwable)e);
            }
        }
    }
}

