/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.connection;

import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsSession
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsSession.class);
    private final Session session;
    private String ackId;

    public JmsSession(Session session) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"A non null Session is required to use as delegate");
        this.session = session;
    }

    public JmsSession(Session session, String ackId) {
        this.session = session;
        this.ackId = ackId;
    }

    public Session get() {
        return this.session;
    }

    public Optional<String> getAckId() {
        return Optional.ofNullable(this.ackId);
    }

    @Override
    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing session " + this.session);
        }
        this.session.close();
    }
}

