/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.connection.factory.jndi;

import java.util.Map;
import org.mule.extensions.jms.api.connection.factory.jndi.JndiNameResolver;
import org.mule.extensions.jms.api.connection.factory.jndi.JndiNameResolverProperties;
import org.mule.extensions.jms.api.connection.factory.jndi.SimpleJndiNameResolver;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExclusiveOptionals(isOneRequired=true)
public final class JndiNameResolverProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiNameResolverProvider.class);
    @Parameter
    @Optional
    private JndiNameResolver customJndiNameResolver;
    @Parameter
    @Optional
    private JndiNameResolverProperties nameResolverBuilder;

    public JndiNameResolver getCustomJndiNameResolver() {
        return this.customJndiNameResolver;
    }

    public JndiNameResolverProperties getNameResolverBuilder() {
        return this.nameResolverBuilder;
    }

    JndiNameResolver createDefaultJndiResolver() throws InitialisationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating default JndiNameResolver");
            LOGGER.debug(String.format("Provider Url: [%s], InitialContextFactory: [%s]", this.nameResolverBuilder.getJndiProviderUrl(), this.nameResolverBuilder.getJndiInitialContextFactory()));
        }
        SimpleJndiNameResolver nameResolver = new SimpleJndiNameResolver();
        nameResolver.setJndiProviderUrl(this.nameResolverBuilder.getJndiProviderUrl());
        nameResolver.setJndiInitialFactory(this.nameResolverBuilder.getJndiInitialContextFactory());
        nameResolver.setJndiProviderProperties((Map)this.nameResolverBuilder.getProviderProperties());
        return nameResolver;
    }
}

