/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.destination;

import org.apache.commons.lang.StringUtils;
import org.mule.extensions.jms.api.destination.ConsumerType;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="topic-consumer")
public final class TopicConsumer
implements ConsumerType,
Initialisable {
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Allows an application to receive all the messages published on a topic, including the ones published when there is no consumer associated with it")
    private boolean isDurable;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Only for JMS 2.0: Allows the processing of messages from at topic subscription by multiple threads, connections or JVMs")
    private boolean isShared;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Specifies that messages published to the topic by its own connection must not be added to the subscription")
    private boolean noLocal;
    @Parameter
    @Optional
    @XmlHints(allowReferences=false)
    @Summary(value="The name to be used for the subscription")
    private String subscriptionName;

    @Override
    public boolean isTopic() {
        return true;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void initialise() throws InitialisationException {
        if (!StringUtils.isBlank((String)this.subscriptionName)) {
            Preconditions.checkArgument((this.isShared() || this.isDurable() ? 1 : 0) != 0, (String)String.format("A [subscriptionName] was provided, but the subscription is neither [durable] nor [shared]", new Object[0]));
        } else {
            Preconditions.checkArgument((!this.isShared() && !this.isDurable() ? 1 : 0) != 0, (String)String.format("No [subscriptionName] was provided, but one is required to create a [durable] or [shared] subscriber", new Object[0]));
        }
        Preconditions.checkArgument((!this.isShared() || !this.isNoLocal() ? 1 : 0) != 0, (String)"A [shared] topic consumer can't be [noLocal]");
    }
}

