/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.message;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.commons.lang.StringUtils;
import org.mule.extensions.jms.api.config.JmsConfig;
import org.mule.extensions.jms.api.config.JmsProducerConfig;
import org.mule.extensions.jms.api.destination.JmsDestination;
import org.mule.extensions.jms.api.exception.DestinationNotFoundException;
import org.mule.extensions.jms.api.message.JmsxProperties;
import org.mule.extensions.jms.internal.common.JmsOperationCommons;
import org.mule.extensions.jms.internal.message.JMSXDefinedPropertiesNames;
import org.mule.extensions.jms.internal.message.JmsMessageUtils;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageBuilder.class);
    public static final String BODY_CONTENT_TYPE_JMS_PROPERTY = "MM_MESSAGE_CONTENT_TYPE";
    public static final String BODY_ENCODING_JMS_PROPERTY = "MM_MESSAGE_ENCODING";
    @Parameter
    @XmlHints(allowReferences=false)
    @Content(primary=true)
    private Object body;
    @Parameter
    @Optional
    private String jmsType;
    @Parameter
    @Optional
    private String correlationId;
    @Parameter
    @Optional(defaultValue="true")
    private boolean sendContentType;
    @Parameter
    @Optional
    @DisplayName(value="ContentType")
    private String contentType;
    @Parameter
    @Optional(defaultValue="true")
    private boolean sendEncoding;
    @Parameter
    @Optional
    @DisplayName(value="Encoding")
    private String encoding;
    @Parameter
    @Optional
    @Summary(value="The destination where a reply to the message should be sent")
    private JmsDestination replyTo;
    @Content
    @Parameter
    @Optional
    @NullSafe
    private Map<String, Object> properties;
    @Parameter
    @Optional
    @NullSafe
    private JmsxProperties jmsxProperties;

    public Message build(JmsSupport jmsSupport, Session session, JmsConfig config) throws JMSException {
        Message message = JmsMessageUtils.toMessage(this.body, session);
        this.setJmsCorrelationIdHeader(message);
        this.setJmsTypeHeader(config.getProducerConfig(), message);
        this.setJmsReplyToHeader(jmsSupport, session, message, this.replyTo);
        this.setJmsxProperties(message);
        this.setUserProperties(message);
        if (this.sendContentType) {
            this.setContentTypeProperty(config, message);
        }
        if (this.sendEncoding) {
            this.setEncodingProperty(config, message);
        }
        return message;
    }

    private void setJmsReplyToHeader(JmsSupport jmsSupport, Session session, Message message, JmsDestination replyDestination) {
        try {
            if (replyDestination != null && !StringUtils.isBlank((String)replyDestination.getDestination())) {
                Destination destination = jmsSupport.createDestination(session, replyDestination.getDestination(), replyDestination.getDestinationType().isTopic());
                message.setJMSReplyTo(destination);
            }
        }
        catch (JMSException | DestinationNotFoundException e) {
            LOGGER.error("Unable to set JMSReplyTo header: ", (Throwable)e);
        }
    }

    private void setEncodingProperty(JmsConfig config, Message message) {
        try {
            message.setStringProperty(BODY_ENCODING_JMS_PROPERTY, JmsOperationCommons.resolveOverride(config.getEncoding(), this.encoding));
        }
        catch (JMSException e) {
            LOGGER.error(String.format("Unable to set property [%s] of type String: ", BODY_ENCODING_JMS_PROPERTY), (Throwable)e);
        }
    }

    private void setContentTypeProperty(JmsConfig config, Message message) {
        try {
            message.setStringProperty(BODY_CONTENT_TYPE_JMS_PROPERTY, JmsOperationCommons.resolveOverride(config.getContentType(), this.contentType));
        }
        catch (JMSException e) {
            LOGGER.error(String.format("Unable to set property [%s] of type String: ", BODY_CONTENT_TYPE_JMS_PROPERTY), (Throwable)e);
        }
    }

    private void setJmsxProperties(Message message) {
        this.jmsxProperties.asMap().entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> this.setJmsPropertySanitizeKeyIfNecessary(message, (String)e.getKey(), e.getValue()));
    }

    private void setUserProperties(Message message) {
        this.properties.keySet().stream().filter(key -> !StringUtils.isBlank((String)key) && !JMSXDefinedPropertiesNames.JMSX_NAMES.contains(key)).forEach(key -> this.setJmsPropertySanitizeKeyIfNecessary(message, (String)key, this.properties.get(key)));
    }

    private void setJmsPropertySanitizeKeyIfNecessary(Message msg, String key, Object value) {
        block3: {
            try {
                key = JmsMessageUtils.encodeKey(key);
                if (value instanceof TypedValue) {
                    value = ((TypedValue)value).getValue();
                }
                msg.setObjectProperty(key, value);
            }
            catch (JMSException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(String.format("Unable to set property [%s] of type [%s]: ", key, value.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    private void setJmsTypeHeader(JmsProducerConfig config, Message message) {
        try {
            String type = JmsOperationCommons.resolveOverride(config.getJmsType(), this.jmsType);
            if (!StringUtils.isBlank((String)type)) {
                message.setJMSType(type);
            }
        }
        catch (JMSException e) {
            LOGGER.error("An error occurred while setting the JMSType property: %s", (Throwable)e);
        }
    }

    private void setJmsCorrelationIdHeader(Message message) {
        try {
            if (!StringUtils.isBlank((String)this.correlationId)) {
                message.setJMSCorrelationID(this.correlationId);
            }
        }
        catch (JMSException e) {
            LOGGER.error("An error occurred while setting the JMSCorrelationID property: %s", (Throwable)e);
        }
    }

    public Object getBody() {
        return this.body;
    }

    public boolean isSendContentType() {
        return this.sendContentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getJmsType() {
        return this.jmsType;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public JmsxProperties getJmsxProperties() {
        return this.jmsxProperties;
    }

    public JmsDestination getReplyTo() {
        return this.replyTo;
    }

    public boolean isSendEncoding() {
        return this.sendEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

