/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.operation;

import org.mule.extensions.jms.api.connection.JmsConnection;
import org.mule.extensions.jms.api.exception.JmsAckErrorTypeProvider;
import org.mule.extensions.jms.api.exception.JmsAckException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsAck {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsAck.class);

    @Throws(value={JmsAckErrorTypeProvider.class})
    public void ack(@Connection JmsConnection connection, @Summary(value="The AckId of the Message to ACK") String ackId) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Performing ACK on session: " + ackId);
            }
            connection.doAck(ackId);
        }
        catch (Exception e) {
            LOGGER.error(String.format("An error occurred while acking a message with ID [%s]: ", ackId), (Throwable)e);
            throw new JmsAckException(String.format("An error occurred while trying to perform an ACK on Session with ID [%s]: ", ackId), e);
        }
    }
}

