/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.api.operation;

import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.mule.extensions.jms.api.config.AckMode;
import org.mule.extensions.jms.api.config.JmsConfig;
import org.mule.extensions.jms.api.connection.JmsConnection;
import org.mule.extensions.jms.api.connection.JmsSession;
import org.mule.extensions.jms.api.destination.ConsumerType;
import org.mule.extensions.jms.api.destination.QueueConsumer;
import org.mule.extensions.jms.api.destination.TopicConsumer;
import org.mule.extensions.jms.api.exception.JmsConsumeException;
import org.mule.extensions.jms.api.exception.JmsExtensionException;
import org.mule.extensions.jms.api.exception.JmsPublishConsumeErrorTypeProvider;
import org.mule.extensions.jms.api.exception.JmsPublishException;
import org.mule.extensions.jms.api.message.JmsAttributes;
import org.mule.extensions.jms.api.message.MessageBuilder;
import org.mule.extensions.jms.internal.common.JmsOperationCommons;
import org.mule.extensions.jms.internal.consume.JmsMessageConsumer;
import org.mule.extensions.jms.internal.message.JmsResultFactory;
import org.mule.extensions.jms.internal.metadata.JmsOutputResolver;
import org.mule.extensions.jms.internal.publish.JmsPublishParameters;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPublishConsume {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsPublishConsume.class);
    private JmsResultFactory resultFactory = new JmsResultFactory();

    @OutputResolver(output=JmsOutputResolver.class)
    @Throws(value={JmsPublishConsumeErrorTypeProvider.class})
    public Result<Object, JmsAttributes> publishConsume(@UseConfig JmsConfig config, @Connection JmsConnection connection, @Placement(order=0) @XmlHints(allowReferences=false) @Summary(value="The name of the Destination where the Message should be sent") String destination, @Optional @NullSafe @Placement(order=1) @Summary(value="A builder for the message that will be published") MessageBuilder messageBuilder, @Optional AckMode ackMode, @Optional(defaultValue="10000") @Summary(value="Maximum time to wait for a response before timeout") long maximumWait, @Optional(defaultValue="MILLISECONDS") @Summary(value="Time unit to be used in the maximumWaitTime configuration") TimeUnit maximumWaitUnit, @Placement(order=2) @ParameterGroup(name="Publish Configuration") JmsPublishParameters overrides) throws JmsExtensionException {
        ConsumerType replyConsumerType;
        Message message;
        JmsSession session;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin publish");
            }
            JmsSupport jmsSupport = connection.getJmsSupport();
            session = connection.createSession(AckMode.AUTO, false);
            message = messageBuilder.build(jmsSupport, session.get(), config);
            replyConsumerType = this.setReplyDestination(messageBuilder, session, jmsSupport, message);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Message built, sending message to [%s]", destination));
            }
            Destination jmsDestination = jmsSupport.createDestination(session.get(), destination, false);
            connection.createProducer(session.get(), jmsDestination, false).publish(message, config.getProducerConfig(), overrides);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Message sent to destination [%s], prepare for response.", destination));
            }
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while sending a message to destination [%s] of type QUEUE: ", destination);
            LOGGER.error(msg, (Throwable)e);
            throw new JmsPublishException(msg, e);
        }
        try {
            Message received;
            JmsMessageConsumer consumer = connection.createConsumer(session.get(), message.getJMSReplyTo(), "", replyConsumerType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Waiting for incoming message in destination [%s]", this.getReplyDestinationName(message.getJMSReplyTo(), replyConsumerType)));
            }
            if ((received = consumer.consume(maximumWaitUnit.toMillis(maximumWait))) != null) {
                ackMode = JmsOperationCommons.resolveOverride(config.getConsumerConfig().getAckMode(), ackMode);
                JmsOperationCommons.evaluateMessageAck(connection, ackMode, session, received);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating response result");
            }
            return this.resultFactory.createResult(received, connection.getJmsSupport().getSpecification(), JmsOperationCommons.resolveMessageContentType(message, config.getContentType()), config.getEncoding(), session.getAckId());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while listening for the reply: ", (Throwable)e);
            throw new JmsConsumeException("An error occurred while listening for the reply: ", e);
        }
    }

    private ConsumerType setReplyDestination(MessageBuilder messageBuilder, JmsSession session, JmsSupport jmsSupport, Message message) throws JMSException {
        if (message.getJMSReplyTo() != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Using provided destination: [%s]", messageBuilder.getReplyTo().getDestination()));
            }
            return messageBuilder.getReplyTo().getDestinationType().isTopic() ? new TopicConsumer() : new QueueConsumer();
        }
        Destination temporaryDestination = jmsSupport.createTemporaryDestination(session.get());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Using temporary destination: [%s]", ((Queue)temporaryDestination).getQueueName()));
        }
        message.setJMSReplyTo(temporaryDestination);
        return new QueueConsumer();
    }

    private String getReplyDestinationName(Destination destination, ConsumerType replyConsumerType) throws JMSException {
        return replyConsumerType.isTopic() ? ((Topic)destination).getTopicName() : ((Queue)destination).getQueueName();
    }
}

