/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.connection.provider;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.lang.StringUtils;
import org.mule.extensions.jms.api.connection.JmsConnection;
import org.mule.extensions.jms.api.connection.JmsSpecification;
import org.mule.extensions.jms.api.connection.caching.CachingStrategy;
import org.mule.extensions.jms.api.connection.caching.DefaultCachingStrategy;
import org.mule.extensions.jms.api.exception.JmsCallbackConnectionException;
import org.mule.extensions.jms.internal.connection.JmsCachingConnectionFactory;
import org.mule.extensions.jms.internal.connection.param.GenericConnectionParameters;
import org.mule.extensions.jms.internal.support.Jms102bSupport;
import org.mule.extensions.jms.internal.support.Jms11Support;
import org.mule.extensions.jms.internal.support.Jms20Support;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnectionProvider
implements PoolingConnectionProvider<JmsConnection>,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseConnectionProvider.class);
    @ParameterGroup(name="Connection")
    private GenericConnectionParameters connectionParameters;
    @Parameter
    @Optional
    @NullSafe(defaultImplementingType=DefaultCachingStrategy.class)
    private CachingStrategy cachingStrategy;
    private AtomicBoolean disconnecting = new AtomicBoolean(false);
    private JmsSupport jmsSupport;
    private ConnectionFactory jmsConnectionFactory;
    private boolean isCacheEnabled = false;

    public abstract ConnectionFactory getConnectionFactory() throws Exception;

    public void initialise() throws InitialisationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Executing initialise for [%s]", this.getClass().getName()));
        }
        try {
            this.createJmsSupport();
            this.initialiseConnectionFactory();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Failed to initialise [%s]: ", this.getClass().getName()), (Throwable)e);
            }
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public JmsConnection connect() throws ConnectionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Connection Started");
        }
        this.disconnecting.set(false);
        try {
            Connection connection = this.createConnection();
            connection.start();
            return new JmsConnection(this.jmsSupport, connection);
        }
        catch (Exception e) {
            block6: {
                try {
                    LifecycleUtils.stopIfNeeded((Object)this.jmsConnectionFactory);
                }
                catch (MuleException factoryStopException) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug("Failed to reset cached connection: ", (Throwable)factoryStopException);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed create connection: ", (Throwable)e);
            }
            throw new ConnectionException((Throwable)e);
        }
    }

    public ConnectionValidationResult validate(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Validating connection");
        }
        try {
            jmsConnection.get().start();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Validation failed: ", (Throwable)e);
            }
            return ConnectionValidationResult.failure((String)"Invalid connection provided: Connection could not be started.", (Exception)e);
        }
    }

    public void disconnect(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Disconnection Started");
        }
        this.disconnecting.set(true);
        this.doStop(jmsConnection);
        this.doClose(jmsConnection);
    }

    public void onReturn(JmsConnection connection) {
        connection.releaseResources();
    }

    protected void doStop(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doStop: [%s]", this.getClass().getName()));
        }
        try {
            LifecycleUtils.stopIfNeeded((Object)jmsConnection);
        }
        catch (Exception e) {
            LOGGER.warn("Jms connection failed to stop properly: ", (Throwable)e);
        }
    }

    protected void doClose(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doClose: [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)jmsConnection, (Logger)LOGGER);
    }

    public void dispose() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Disposing [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)this.jmsConnectionFactory, (Logger)LOGGER);
    }

    private void initialiseConnectionFactory() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialising Connection Factory");
        }
        ConnectionFactory targetFactory = this.getConnectionFactory();
        LifecycleUtils.initialiseIfNeeded((Object)targetFactory);
        if (this.cachingStrategy.appliesTo(targetFactory) && this.cachingStrategy.strategyConfiguration().isPresent()) {
            this.isCacheEnabled = true;
            String username = this.getConnectionParameters().getUsername();
            String password = this.getConnectionParameters().getPassword();
            String clientId = this.getConnectionParameters().getClientId();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Using CachingConnectionFactory wrapper with: username:[%s], password:[%s], clientId:[%s]", username, password, clientId));
            }
            this.jmsConnectionFactory = new JmsCachingConnectionFactory(targetFactory, username, password, clientId, this.cachingStrategy.strategyConfiguration().get(), this.jmsSupport, this.getExceptionListener());
            LifecycleUtils.initialiseIfNeeded((Object)this.jmsConnectionFactory);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Skip CachingConnectionFactory Wrapper", new Object[0]));
            }
            this.jmsConnectionFactory = targetFactory;
        }
    }

    protected void createJmsSupport() {
        JmsSpecification specification = this.getConnectionParameters().getSpecification();
        this.jmsSupport = JmsSpecification.JMS_1_0_2b.equals((Object)specification) ? new Jms102bSupport() : (JmsSpecification.JMS_2_0.equals((Object)specification) ? new Jms20Support() : new Jms11Support());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("JMS Support set to [%s]", this.jmsSupport.getSpecification().getName()));
        }
    }

    private Connection createConnection() throws JMSException {
        Connection connection;
        block6: {
            String username = this.getConnectionParameters().getUsername();
            String password = this.getConnectionParameters().getPassword();
            connection = this.isCacheEnabled || StringUtils.isBlank((String)username) ? this.jmsSupport.createConnection(this.jmsConnectionFactory) : this.jmsSupport.createConnection(this.jmsConnectionFactory, username, password);
            if (connection == null) {
                throw new IllegalStateException("An error occurred, Connection cannot be null after creation");
            }
            if (!this.isCacheEnabled) {
                String clientId = this.getConnectionParameters().getClientId();
                if (!StringUtils.isBlank((String)clientId) && !clientId.equals(connection.getClientID())) {
                    connection.setClientID(clientId);
                }
                if (connection.getExceptionListener() == null) {
                    try {
                        connection.setExceptionListener(this.getExceptionListener());
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block6;
                        LOGGER.debug("An error occurred while setting the ExceptionListener. No ExceptionListener is available in a Java EE web or EJB application. ", (Throwable)e);
                    }
                }
            }
        }
        return connection;
    }

    private ExceptionListener getExceptionListener() {
        return e -> {
            if (!this.disconnecting.get()) {
                throw new JmsCallbackConnectionException(e);
            }
        };
    }

    public GenericConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    protected void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }
}

