/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.connection.provider;

import javax.jms.ConnectionFactory;
import org.mule.extensions.jms.api.connection.JmsSpecification;
import org.mule.extensions.jms.api.connection.LookupJndiDestination;
import org.mule.extensions.jms.api.connection.factory.jndi.JndiConnectionFactory;
import org.mule.extensions.jms.internal.connection.provider.BaseConnectionProvider;
import org.mule.extensions.jms.internal.support.Jms102bSupport;
import org.mule.extensions.jms.internal.support.Jms11Support;
import org.mule.extensions.jms.internal.support.Jms20Support;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="generic")
public class GenericConnectionProvider
extends BaseConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseConnectionProvider.class);
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ConnectionFactory connectionFactory;

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    protected void createJmsSupport() {
        if (!(this.connectionFactory instanceof JndiConnectionFactory)) {
            super.createJmsSupport();
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating JMSSupport using a Jndi discovered Connection Factory");
        }
        JndiConnectionFactory jndiConnectionFactory = (JndiConnectionFactory)this.connectionFactory;
        LookupJndiDestination lookupJndiDestination = jndiConnectionFactory.getLookupDestination();
        JmsSpecification specification = this.getConnectionParameters().getSpecification();
        if (JmsSpecification.JMS_1_0_2b.equals((Object)specification)) {
            this.setJmsSupport(new Jms102bSupport(lookupJndiDestination, jndiConnectionFactory::getJndiDestination));
        } else if (JmsSpecification.JMS_1_1.equals((Object)specification)) {
            this.setJmsSupport(new Jms11Support(lookupJndiDestination, jndiConnectionFactory::getJndiDestination));
        } else {
            this.setJmsSupport(new Jms20Support(lookupJndiDestination, jndiConnectionFactory::getJndiDestination));
        }
    }
}

