/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.connection.provider.activemq;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.ConnectionFactory;
import org.mule.extensions.jms.api.connection.factory.activemq.ActiveMQConnectionFactoryConfiguration;
import org.mule.extensions.jms.internal.connection.exception.ActiveMQException;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExclusiveOptionals
public class ActiveMQConnectionFactoryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQConnectionFactoryProvider.class);
    private static final String ACTIVEMQ_CONNECTION_FACTORY_CLASS = "org.apache.activemq.ActiveMQConnectionFactory";
    private static final String ACTIVEMQ_XA_CONNECTION_FACTORY_CLASS = "org.apache.activemq.ActiveMQXAConnectionFactory";
    private static final int REDELIVERY_IGNORE = -1;
    @Parameter
    @Optional
    private ConnectionFactory connectionFactory;
    @Parameter
    @Optional
    @NullSafe
    private ActiveMQConnectionFactoryConfiguration factoryConfiguration;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    ConnectionFactory createDefaultConnectionFactory() throws ActiveMQException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Creating new [%s]", this.getFactoryClass()));
            }
            this.connectionFactory = (ConnectionFactory)ClassUtils.instanciateClass((String)this.getFactoryClass(), (Object[])new Object[]{this.factoryConfiguration.getBrokerUrl()});
            this.applyVendorSpecificConnectionFactoryProperties(this.connectionFactory);
            return this.connectionFactory;
        }
        catch (Exception e) {
            String message = String.format("Failed to create a default Connection Factory for ActiveMQ using the [%s] implementation: ", this.getFactoryClass());
            LOGGER.error(message, (Throwable)e);
            throw new ActiveMQException(message, e);
        }
    }

    private void applyVendorSpecificConnectionFactoryProperties(ConnectionFactory connectionFactory) {
        try {
            Method getRedeliveryPolicyMethod = connectionFactory.getClass().getMethod("getRedeliveryPolicy", new Class[0]);
            Object redeliveryPolicy = getRedeliveryPolicyMethod.invoke((Object)connectionFactory, new Object[0]);
            this.setMaximumRedeliveries(redeliveryPolicy);
            this.setInitialRedeliveryDelay(redeliveryPolicy);
            this.setRedeliveryDelay(redeliveryPolicy);
        }
        catch (Exception e) {
            LOGGER.error("Failed to set custom ConnectionFactoryProperties for ActiveMQ RedeliveryPolicy ", (Throwable)e);
        }
    }

    private void setMaximumRedeliveries(Object redeliveryPolicy) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setMaximumRedeliveriesMethod = redeliveryPolicy.getClass().getMethod("setMaximumRedeliveries", Integer.TYPE);
        int maxRedelivery = this.factoryConfiguration.getMaxRedelivery();
        if (maxRedelivery != -1) {
            ++maxRedelivery;
        }
        setMaximumRedeliveriesMethod.invoke(redeliveryPolicy, maxRedelivery);
    }

    private void setInitialRedeliveryDelay(Object redeliveryPolicy) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setInitialRedeliveryDelayMethod = redeliveryPolicy.getClass().getMethod("setInitialRedeliveryDelay", Long.TYPE);
        setInitialRedeliveryDelayMethod.invoke(redeliveryPolicy, this.factoryConfiguration.getInitialRedeliveryDelay());
    }

    private void setRedeliveryDelay(Object redeliveryPolicy) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setRedeliveryDelayMethod = redeliveryPolicy.getClass().getMethod("setRedeliveryDelay", Long.TYPE);
        setRedeliveryDelayMethod.invoke(redeliveryPolicy, this.factoryConfiguration.getRedeliveryDelay());
    }

    private String getFactoryClass() {
        return this.factoryConfiguration.isEnableXA() ? ACTIVEMQ_XA_CONNECTION_FACTORY_CLASS : ACTIVEMQ_CONNECTION_FACTORY_CLASS;
    }
}

