/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.connection.provider.activemq;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.mule.extensions.jms.api.connection.JmsConnection;
import org.mule.extensions.jms.api.connection.JmsSpecification;
import org.mule.extensions.jms.internal.connection.exception.ActiveMQException;
import org.mule.extensions.jms.internal.connection.provider.BaseConnectionProvider;
import org.mule.extensions.jms.internal.connection.provider.activemq.ActiveMQConnectionFactoryProvider;
import org.mule.runtime.core.util.proxy.TargetInvocationHandler;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="active-mq")
public class ActiveMQConnectionProvider
extends BaseConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQConnectionProvider.class);
    @ParameterGroup(name="Connection Factory")
    private ActiveMQConnectionFactoryProvider connectionFactoryProvider;
    private ConnectionFactory connectionFactory;

    @Override
    public ConnectionFactory getConnectionFactory() throws ActiveMQException {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        this.createConnectionFactory();
        return this.connectionFactory;
    }

    private void createConnectionFactory() throws ActiveMQException {
        this.connectionFactory = this.connectionFactoryProvider.getConnectionFactory();
        if (this.connectionFactory == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No custom connection factory provided, creating the default for ActiveMq");
            }
            if (JmsSpecification.JMS_2_0.equals((Object)this.getConnectionParameters().getSpecification())) {
                throw new ActiveMQException("No ConnectionFactory was provided, but JMS 2.0 specification was selected. Default ActiveMQConnectionFactory implementation provides support only for JMS 1.1 and 1.0.2b versions");
            }
            this.connectionFactory = this.connectionFactoryProvider.createDefaultConnectionFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Performing custom doClose for ActiveMq");
        }
        Connection connection = jmsConnection.get();
        try {
            this.executeCleanup(connection);
        }
        catch (Exception e) {
            LOGGER.warn("Exception cleaning up ActiveMQ JMS connection: ", (Throwable)e);
        }
        finally {
            super.doClose(jmsConnection);
        }
    }

    private void executeCleanup(Connection connection) throws Exception {
        Method cleanupMethod;
        block8: {
            cleanupMethod = null;
            try {
                Class<?> clazz = connection.getClass();
                if (Proxy.isProxyClass(clazz)) {
                    InvocationHandler invocationHandler = Proxy.getInvocationHandler(connection);
                    if (invocationHandler instanceof TargetInvocationHandler) {
                        TargetInvocationHandler targetInvocationHandler = (TargetInvocationHandler)invocationHandler;
                        connection = (Connection)targetInvocationHandler.getTargetObject();
                        Class<?> realConnectionClass = connection.getClass();
                        cleanupMethod = realConnectionClass.getMethod("cleanup", null);
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("InvocationHandler of the JMS connection proxy is of type %s, not doing any extra cleanup", invocationHandler.getClass().getName()));
                    }
                } else {
                    cleanupMethod = clazz.getMethod("cleanup", null);
                }
            }
            catch (NoSuchMethodException e) {
                if (!LOGGER.isDebugEnabled()) break block8;
                LOGGER.debug("Failed to perform a deep cleanup on ActiveMQ connection: ", (Throwable)e);
            }
        }
        if (cleanupMethod != null) {
            cleanupMethod.invoke((Object)connection, (Object[])null);
        }
    }

    public ActiveMQConnectionFactoryProvider getConnectionFactoryProvider() {
        return this.connectionFactoryProvider;
    }
}

