/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.message;

import java.util.Optional;
import org.mule.extensions.jms.api.message.JmsAttributes;
import org.mule.extensions.jms.api.message.JmsHeaders;
import org.mule.extensions.jms.api.message.JmsMessageProperties;
import org.mule.runtime.api.util.Preconditions;

class DefaultJmsAttributes
implements JmsAttributes {
    private final JmsMessageProperties properties;
    private final JmsHeaders headers;
    private final String ackId;

    public DefaultJmsAttributes(JmsMessageProperties properties, JmsHeaders headers, String ackId) {
        this.properties = properties;
        this.headers = headers;
        this.ackId = ackId;
    }

    @Override
    public JmsMessageProperties getProperties() {
        return this.properties;
    }

    @Override
    public JmsHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public Optional<String> getAckId() {
        return Optional.ofNullable(this.ackId);
    }

    public static class Builder {
        private JmsMessageProperties properties;
        private JmsHeaders headers;
        private String ackId;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withProperties(JmsMessageProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder withHeaders(JmsHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder withAckId(String ackId) {
            this.ackId = ackId;
            return this;
        }

        public JmsAttributes build() {
            Preconditions.checkArgument((this.properties != null ? 1 : 0) != 0, (String)"No JmsMessageProperties were provided, but they are required for the JmsAttributes");
            Preconditions.checkArgument((this.headers != null ? 1 : 0) != 0, (String)"No JmsHeaders were provided, but they are required for the JmsAttributes");
            return new DefaultJmsAttributes(this.properties, this.headers, this.ackId);
        }
    }
}

