/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.message;

import org.mule.extensions.jms.api.destination.JmsDestination;
import org.mule.extensions.jms.api.message.JmsHeaders;

final class DefaultJmsHeaders
implements JmsHeaders {
    private JmsDestination destination;
    private Integer deliveryMode;
    private Long expiration;
    private Integer priority;
    private String messageId;
    private Long timestamp;
    private String correlactionId;
    private JmsDestination replyTo;
    private String type;
    private Boolean redelivered;
    private Long deliveryTime;

    private DefaultJmsHeaders() {
    }

    @Override
    public String getJMSMessageID() {
        return this.messageId;
    }

    @Override
    public Long getJMSTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getJMSCorrelationID() {
        return this.correlactionId;
    }

    @Override
    public JmsDestination getJMSReplyTo() {
        return this.replyTo;
    }

    @Override
    public JmsDestination getJMSDestination() {
        return this.destination;
    }

    @Override
    public Integer getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public Boolean getJMSRedelivered() {
        return this.redelivered;
    }

    @Override
    public String getJMSType() {
        return this.type;
    }

    @Override
    public Long getJMSExpiration() {
        return this.expiration;
    }

    @Override
    public Long getJMSDeliveryTime() {
        return this.deliveryTime;
    }

    @Override
    public Integer getJMSPriority() {
        return this.priority;
    }

    public static class Builder {
        private DefaultJmsHeaders jmsHeaders = new DefaultJmsHeaders();

        public Builder setMessageId(String messageId) {
            this.jmsHeaders.messageId = messageId;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.jmsHeaders.timestamp = timestamp;
            return this;
        }

        public Builder setCorrelactionId(String correlationId) {
            this.jmsHeaders.correlactionId = correlationId;
            return this;
        }

        public Builder setReplyTo(JmsDestination replyTo) {
            this.jmsHeaders.replyTo = replyTo;
            return this;
        }

        public Builder setDestination(JmsDestination destination) {
            this.jmsHeaders.destination = destination;
            return this;
        }

        public Builder setDeliveryMode(int deliveryMode) {
            this.jmsHeaders.deliveryMode = deliveryMode;
            return this;
        }

        public Builder setRedelivered(boolean redelivered) {
            this.jmsHeaders.redelivered = redelivered;
            return this;
        }

        public Builder setType(String type) {
            this.jmsHeaders.type = type;
            return this;
        }

        public Builder setExpiration(long expiration) {
            this.jmsHeaders.expiration = expiration;
            return this;
        }

        public Builder setPriority(int priority) {
            this.jmsHeaders.priority = priority;
            return this;
        }

        public Builder setDeliveryTime(long deliveryTime) {
            this.jmsHeaders.deliveryTime = deliveryTime;
            return this;
        }

        public DefaultJmsHeaders build() {
            return this.jmsHeaders;
        }
    }
}

