/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.message;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.mule.extensions.jms.api.message.JmsMessageProperties;
import org.mule.extensions.jms.api.message.JmsxProperties;
import org.mule.extensions.jms.internal.message.JMSXDefinedPropertiesNames;
import org.mule.extensions.jms.internal.message.JmsxPropertiesBuilder;
import org.mule.runtime.api.util.Preconditions;

public class DefaultJmsProperties
implements JmsMessageProperties {
    private static final String JMSX_PREFIX = "JMSX";
    private static final String JMS_PREFIX = "JMS";
    private final Map<String, Object> allPropertiesMap;
    private final Map<String, Object> userProperties = new HashMap<String, Object>();
    private final Map<String, Object> jmsProperties = new HashMap<String, Object>();
    private JmsxProperties jmsxProperties;

    public DefaultJmsProperties(Map<String, Object> messageProperties) {
        Preconditions.checkArgument((messageProperties != null ? 1 : 0) != 0, (String)"Initializer properties Map expected, but it was null");
        this.allPropertiesMap = ImmutableMap.copyOf(messageProperties);
        JmsxPropertiesBuilder jmsxPropertiesBuilder = JmsxPropertiesBuilder.create();
        this.allPropertiesMap.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            if (key.startsWith(JMSX_PREFIX) && JMSXDefinedPropertiesNames.JMSX_NAMES.contains(key)) {
                jmsxPropertiesBuilder.add(key, e.getValue());
            } else if (key.startsWith(JMS_PREFIX)) {
                this.jmsProperties.put(key, e.getValue());
            } else {
                this.userProperties.put(key, e.getValue());
            }
        });
        this.jmsxProperties = jmsxPropertiesBuilder.build();
    }

    @Override
    public Map<String, Object> asMap() {
        return ImmutableMap.copyOf(this.allPropertiesMap);
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return ImmutableMap.copyOf(this.userProperties);
    }

    @Override
    public Map<String, Object> getJmsProperties() {
        return ImmutableMap.copyOf(this.jmsProperties);
    }

    @Override
    public JmsxProperties getJmsxProperties() {
        return this.jmsxProperties;
    }

    public boolean equals(Object o) {
        return this.allPropertiesMap.equals(o);
    }

    public int hashCode() {
        return this.allPropertiesMap.hashCode();
    }
}

