/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.publish;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.mule.extensions.jms.api.config.JmsProducerConfig;
import org.mule.extensions.jms.api.connection.JmsSpecification;
import org.mule.extensions.jms.internal.common.JmsOperationCommons;
import org.mule.extensions.jms.internal.publish.JmsPublishParameters;
import org.mule.extensions.jms.internal.support.JmsSupport;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageProducer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageProducer.class);
    private final MessageProducer producer;
    private final JmsSupport jmsSupport;
    private final boolean isTopic;

    public JmsMessageProducer(JmsSupport jmsSupport, MessageProducer producer, boolean isTopic) {
        Preconditions.checkArgument((jmsSupport != null ? 1 : 0) != 0, (String)"A non null JmsSupport implementation is required for publishing");
        Preconditions.checkArgument((producer != null ? 1 : 0) != 0, (String)"A non null MessageProducer is required to use as delegate");
        this.producer = producer;
        this.jmsSupport = jmsSupport;
        this.isTopic = isTopic;
    }

    public void publish(Message message, JmsProducerConfig config, JmsPublishParameters overrides) throws JMSException {
        Optional<Long> delay = this.resolveDeliveryDelay(config, overrides.getDeliveryDelay(), overrides.getDeliveryDelayUnit());
        Boolean disableMessageId = JmsOperationCommons.resolveOverride(config.isDisableMessageId(), overrides.isDisableMessageId());
        Boolean disableMessageTimestamp = JmsOperationCommons.resolveOverride(config.isDisableMessageTimestamp(), overrides.isDisableMessageTimestamp());
        Boolean persistentDelivery = JmsOperationCommons.resolveOverride(config.isPersistentDelivery(), overrides.isPersistentDelivery());
        Integer priority = JmsOperationCommons.resolveOverride(config.getPriority(), overrides.getPriority());
        long timeToLive = JmsOperationCommons.resolveOverride(config.getTimeToLiveUnit(), overrides.getTimeToLiveUnit()).toMillis(JmsOperationCommons.resolveOverride(config.getTimeToLive(), overrides.getTimeToLive()));
        this.configureProducer(delay, disableMessageId, disableMessageTimestamp);
        this.jmsSupport.send(this.producer, message, persistentDelivery, priority, timeToLive, this.isTopic);
    }

    @Override
    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing producer: " + this.producer);
        }
        this.producer.close();
    }

    private Optional<Long> resolveDeliveryDelay(JmsProducerConfig config, Long deliveryDelay, TimeUnit unit) {
        Long delay = JmsOperationCommons.resolveOverride(config.getDeliveryDelay(), deliveryDelay);
        TimeUnit delayUnit = JmsOperationCommons.resolveOverride(config.getDeliveryDelayUnit(), unit);
        Preconditions.checkArgument((this.jmsSupport.getSpecification().equals((Object)JmsSpecification.JMS_2_0) || delay == null ? 1 : 0) != 0, (String)String.format("[deliveryDelay] is only supported on JMS 2.0 specification, but current configuration is set to JMS %s", this.jmsSupport.getSpecification().getName()));
        if (delay != null) {
            return Optional.of(delayUnit.toMillis(delay));
        }
        return Optional.empty();
    }

    private void configureProducer(Optional<Long> deliveryDelay, boolean dissableId, boolean dissableTimeStamp) throws JMSException {
        this.setDisableMessageID(dissableId);
        this.setDisableMessageTimestamp(dissableTimeStamp);
        deliveryDelay.ifPresent(this::setDeliveryDelay);
    }

    private void setDeliveryDelay(Long value) {
        try {
            this.producer.setDeliveryDelay(value.longValue());
        }
        catch (JMSException e) {
            LOGGER.error("Failed to configure [setDeliveryDelay] in MessageProducer: ", (Throwable)e);
        }
    }

    private void setDisableMessageID(boolean value) {
        try {
            this.producer.setDisableMessageID(value);
        }
        catch (JMSException e) {
            LOGGER.error("Failed to configure [setDisableMessageID] in MessageProducer: ", (Throwable)e);
        }
    }

    private void setDisableMessageTimestamp(boolean value) {
        try {
            this.producer.setDisableMessageTimestamp(value);
        }
        catch (JMSException e) {
            LOGGER.error("Failed to configure [setDisableMessageTimestamp] in MessageProducer: ", (Throwable)e);
        }
    }
}

