/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.jms.internal.support;

import java.util.Optional;
import java.util.function.Function;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.extensions.jms.api.connection.JmsSpecification;
import org.mule.extensions.jms.api.connection.LookupJndiDestination;
import org.mule.extensions.jms.api.destination.ConsumerType;
import org.mule.extensions.jms.api.destination.TopicConsumer;
import org.mule.extensions.jms.internal.support.Jms20Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jms11Support
extends Jms20Support {
    private Logger LOGGER = LoggerFactory.getLogger(Jms11Support.class);

    public Jms11Support() {
    }

    public Jms11Support(LookupJndiDestination lookupJndiDestination, Function<String, Optional<Destination>> jndiObjectSupplier) {
        super(lookupJndiDestination, jndiObjectSupplier);
    }

    @Override
    public JmsSpecification getSpecification() {
        return JmsSpecification.JMS_1_1;
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, ConsumerType type) throws JMSException {
        if (!type.isTopic()) {
            return session.createConsumer(destination, messageSelector);
        }
        TopicConsumer topicConsumer = (TopicConsumer)type;
        if (topicConsumer.isDurable()) {
            return session.createDurableSubscriber((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector, topicConsumer.isNoLocal());
        }
        return session.createConsumer(destination, messageSelector, topicConsumer.isNoLocal());
    }
}

