/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.authorizationcode;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.module.http.api.listener.HttpListenerBuilder;
import org.mule.module.oauth2.internal.DynamicFlowFactory;
import org.mule.module.oauth2.internal.StateEncoder;
import org.mule.module.oauth2.internal.authorizationcode.AuthorizationCodeGrantType;
import org.mule.module.oauth2.internal.authorizationcode.AuthorizationRequestUrlBuilder;
import org.mule.util.AttributeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationRequestHandler
implements MuleContextAware {
    public static final String REDIRECT_STATUS_CODE = "302";
    public static final String OAUTH_STATE_ID_FLOW_VAR_NAME = "resourceOwnerId";
    private Logger logger = LoggerFactory.getLogger(AuthorizationRequestHandler.class);
    private String scopes;
    private String state;
    private String localAuthorizationUrl;
    private String authorizationUrl;
    private Map<String, String> customParameters = new HashMap<String, String>();
    private HttpListener listener;
    private MuleContext muleContext;
    private AuthorizationCodeGrantType oauthConfig;
    private AttributeEvaluator stateEvaluator;

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setLocalAuthorizationUrl(String localAuthorizationUrl) {
        this.localAuthorizationUrl = localAuthorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public void init() throws MuleException {
        try {
            this.stateEvaluator = new AttributeEvaluator(this.state).initialize(this.muleContext.getExpressionManager());
            HttpListenerBuilder httpListenerBuilder = new HttpListenerBuilder(this.muleContext);
            String flowName = "authorization-request-handler-" + this.localAuthorizationUrl;
            Flow flow = DynamicFlowFactory.createDynamicFlow(this.muleContext, flowName, this.createLocalAuthorizationUrlListener());
            this.muleContext.getRegistry().registerObject(flow.getName(), (Object)flow);
            httpListenerBuilder.setUrl(new URL(this.localAuthorizationUrl)).setSuccessStatusCode(REDIRECT_STATUS_CODE).setFlow(flow);
            if (this.oauthConfig.getTlsContext() != null) {
                httpListenerBuilder.setTlsContextFactory(this.oauthConfig.getTlsContext());
            }
            this.listener = httpListenerBuilder.build();
            this.listener.initialise();
            this.listener.start();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Could not parse provided url %s. Validate that the url is correct", (Object)this.localAuthorizationUrl);
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private List<MessageProcessor> createLocalAuthorizationUrlListener() {
        MessageProcessor listenerMessageProcessor = new MessageProcessor(){

            public MuleEvent process(MuleEvent muleEvent) throws MuleException {
                String onCompleteRedirectToValue = (String)((Map)muleEvent.getMessage().getInboundProperty("http.query.params")).get("onCompleteRedirectTo");
                String resourceOwnerId = AuthorizationRequestHandler.this.getOauthConfig().getLocalAuthorizationUrlResourceOwnerIdEvaluator().resolveStringValue(muleEvent);
                muleEvent.setFlowVariable(AuthorizationRequestHandler.OAUTH_STATE_ID_FLOW_VAR_NAME, (Object)resourceOwnerId);
                String stateValue = AuthorizationRequestHandler.this.stateEvaluator.resolveStringValue(muleEvent);
                StateEncoder stateEncoder = new StateEncoder(stateValue);
                if (resourceOwnerId != null) {
                    stateEncoder.encodeResourceOwnerIdInState(resourceOwnerId);
                }
                if (onCompleteRedirectToValue != null) {
                    stateEncoder.encodeOnCompleteRedirectToInState(onCompleteRedirectToValue);
                }
                String authorizationUrlWithParams = new AuthorizationRequestUrlBuilder().setAuthorizationUrl(AuthorizationRequestHandler.this.authorizationUrl).setClientId(AuthorizationRequestHandler.this.oauthConfig.getClientId()).setClientSecret(AuthorizationRequestHandler.this.oauthConfig.getClientSecret()).setCustomParameters(AuthorizationRequestHandler.this.customParameters).setRedirectUrl(AuthorizationRequestHandler.this.oauthConfig.getExternalRedirectionUrl()).setState(stateEncoder.getEncodedState()).setScope(AuthorizationRequestHandler.this.scopes).buildUrl();
                muleEvent.getMessage().setOutboundProperty("Location", (Object)authorizationUrlWithParams);
                return muleEvent;
            }
        };
        return Arrays.asList(listenerMessageProcessor);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setOauthConfig(AuthorizationCodeGrantType oauthConfig) {
        this.oauthConfig = oauthConfig;
    }

    public AuthorizationCodeGrantType getOauthConfig() {
        return this.oauthConfig;
    }
}

