/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.client.OperationOptions;
import org.mule.api.context.MuleContextAware;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.api.requester.HttpRequesterConfigBuilder;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenRequestHandler
implements MuleContextAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private MuleContext muleContext;
    private String refreshTokenWhen = "#[message.inboundProperties['http.status'] == 401 || message.inboundProperties['http.status'] == 403]";
    private String tokenUrl;
    private HttpRequestOptions httpRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private TlsContextFactory tlsContextFactory;

    public void setRefreshTokenWhen(String refreshTokenWhen) {
        this.refreshTokenWhen = refreshTokenWhen;
    }

    public String getRefreshTokenWhen() {
        return this.refreshTokenWhen;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void buildHttpRequestOptions(TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig) throws MuleException {
        HttpConstants.Protocols protocol = tlsContextFactory != null ? HttpConstants.Protocols.HTTPS : HttpConstants.Protocols.HTTP;
        HttpRequesterConfig httpRequesterConfig = new HttpRequesterConfigBuilder(this.muleContext).setProxyConfig(proxyConfig).setProtocol(protocol).setTlsContext(tlsContextFactory).build();
        this.httpRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().requestConfig(httpRequesterConfig).build();
    }

    protected MuleEvent invokeTokenUrl(MuleEvent event) throws MuleException, TokenUrlResponseException {
        event.setMessage(this.muleContext.getClient().send(this.tokenUrl, event.getMessage(), (OperationOptions)this.httpRequestOptions));
        if ((Integer)event.getMessage().getInboundProperty("http.status") >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
            throw new TokenUrlResponseException(event);
        }
        return event;
    }

    protected String getTokenUrl() {
        return this.tokenUrl;
    }

    protected class TokenUrlResponseException
    extends Exception {
        private MuleEvent tokenUrlResponse;

        public TokenUrlResponseException(MuleEvent tokenUrlResponse) {
            this.tokenUrlResponse = tokenUrlResponse;
        }

        public MuleEvent getTokenUrlResponse() {
            return this.tokenUrlResponse;
        }
    }
}

