
package org.mule.modules.salesforce.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.salesforce.processors.ConvertLeadMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ConvertLeadDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public ConvertLeadDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConvertLeadMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("leadId")!= null)&&(!StringUtils.isBlank(element.getAttribute("leadId")))) {
            builder.addPropertyValue("leadId", element.getAttribute("leadId"));
        }
        if ((element.getAttribute("contactId")!= null)&&(!StringUtils.isBlank(element.getAttribute("contactId")))) {
            builder.addPropertyValue("contactId", element.getAttribute("contactId"));
        }
        if ((element.getAttribute("accountId")!= null)&&(!StringUtils.isBlank(element.getAttribute("accountId")))) {
            builder.addPropertyValue("accountId", element.getAttribute("accountId"));
        }
        if ((element.getAttribute("overWriteLeadSource")!= null)&&(!StringUtils.isBlank(element.getAttribute("overWriteLeadSource")))) {
            builder.addPropertyValue("overWriteLeadSource", element.getAttribute("overWriteLeadSource"));
        }
        if ((element.getAttribute("doNotCreateOpportunity")!= null)&&(!StringUtils.isBlank(element.getAttribute("doNotCreateOpportunity")))) {
            builder.addPropertyValue("doNotCreateOpportunity", element.getAttribute("doNotCreateOpportunity"));
        }
        if ((element.getAttribute("opportunityName")!= null)&&(!StringUtils.isBlank(element.getAttribute("opportunityName")))) {
            builder.addPropertyValue("opportunityName", element.getAttribute("opportunityName"));
        }
        if ((element.getAttribute("convertedStatus")!= null)&&(!StringUtils.isBlank(element.getAttribute("convertedStatus")))) {
            builder.addPropertyValue("convertedStatus", element.getAttribute("convertedStatus"));
        }
        if ((element.getAttribute("sendEmailToOwner")!= null)&&(!StringUtils.isBlank(element.getAttribute("sendEmailToOwner")))) {
            builder.addPropertyValue("sendEmailToOwner", element.getAttribute("sendEmailToOwner"));
        }
        if ((element.getAttribute("retryMax")!= null)&&(!StringUtils.isBlank(element.getAttribute("retryMax")))) {
            builder.addPropertyValue("retryMax", element.getAttribute("retryMax"));
        }
        if ((element.getAttribute("username")!= null)&&(!StringUtils.isBlank(element.getAttribute("username")))) {
            builder.addPropertyValue("username", element.getAttribute("username"));
        }
        if ((element.getAttribute("password")!= null)&&(!StringUtils.isBlank(element.getAttribute("password")))) {
            builder.addPropertyValue("password", element.getAttribute("password"));
        }
        if ((element.getAttribute("securityToken")!= null)&&(!StringUtils.isBlank(element.getAttribute("securityToken")))) {
            builder.addPropertyValue("securityToken", element.getAttribute("securityToken"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
