
package org.mule.modules.salesforce.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.salesforce.adapters.SalesforceModuleConnectionIdentifierAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated(value = "Mule DevKit Version 3.4-SNAPSHOT", date = "2012-07-18T11:23:17-05:00", comments = "Build UNKNOWN_BUILDNUMBER")
public class SalesforceModuleConnectionFactory implements KeyedPoolableObjectFactory
{

    private static Logger logger = LoggerFactory.getLogger(SalesforceModuleConnectionFactory.class);
    private SalesforceModuleConnectionManager connectionManager;

    public SalesforceModuleConnectionFactory(SalesforceModuleConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key)
        throws Exception
    {
        if (!(key instanceof SalesforceModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        SalesforceModuleConnectionIdentifierAdapter connector = new SalesforceModuleConnectionIdentifierAdapter();
        connector.setUrl(connectionManager.getUrl());
        connector.setProxyHost(connectionManager.getProxyHost());
        connector.setProxyPort(connectionManager.getProxyPort());
        connector.setProxyUsername(connectionManager.getProxyUsername());
        connector.setProxyPassword(connectionManager.getProxyPassword());
        connector.setObjectStore(connectionManager.getObjectStore());
        if (connector instanceof Initialisable) {
            ((Initialisable) connector).initialise();
        }
        if (connector instanceof Startable) {
            ((Startable) connector).start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj)
        throws Exception
    {
        if (!(key instanceof SalesforceModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SalesforceModuleConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((SalesforceModuleConnectionIdentifierAdapter) obj).destroySession();
        } catch (Exception e) {
            throw e;
        } finally {
            if (((SalesforceModuleConnectionIdentifierAdapter) obj) instanceof Stoppable) {
                ((Stoppable) obj).stop();
            }
            if (((SalesforceModuleConnectionIdentifierAdapter) obj) instanceof Disposable) {
                ((Disposable) obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof SalesforceModuleConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((SalesforceModuleConnectionIdentifierAdapter) obj).isConnected();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj)
        throws Exception
    {
        if (!(key instanceof SalesforceModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SalesforceModuleConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            if (!((SalesforceModuleConnectionIdentifierAdapter) obj).isConnected()) {
                ((SalesforceModuleConnectionIdentifierAdapter) obj).connect(((SalesforceModuleConnectionKey) key).getUsername(), ((SalesforceModuleConnectionKey) key).getPassword(), ((SalesforceModuleConnectionKey) key).getSecurityToken());
            }
        } catch (Exception e) {
            throw e;
        }
    }

    public void passivateObject(Object key, Object obj)
        throws Exception
    {
    }

}
