
package org.mule.modules.salesforce.agents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.agent.Agent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.SplashScreenAgent;
import org.mule.api.registry.Registry;
import org.mule.util.StringMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Agent implementation to add splash screen information for DevKit extensions at application startup
 * 
 */
@Generated(value = "Mule DevKit Version 3.4-SNAPSHOT", date = "2012-07-18T11:29:04-05:00", comments = "Build UNKNOWN_BUILDNUMBER")
public class DefaultSplashScreenAgent implements Agent, MuleContextAware, SplashScreenAgent
{

    private int extensionsCount;
    private MuleContext muleContext;
    private static Logger logger = LoggerFactory.getLogger(DefaultSplashScreenAgent.class);

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return "DevKitSplashScreenAgent";
    }

    public String getDescription() {
        return "DevKit Extension Information";
    }

    /**
     * Retrieves extensionsCount
     * 
     */
    public int getExtensionsCount() {
        return this.extensionsCount;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public void initialise() {
    }

    public void splash() {
        Registry registry = muleContext.getRegistry();
        Collection<MetadataAware> metadataAwares = registry.lookupObjects(MetadataAware.class);
        List<String> stringList = new ArrayList<String>();
        extensionsCount = metadataAwares.size();
        if (extensionsCount > 0) {
            for (MetadataAware connectorMetadata: metadataAwares) {
                stringList.add((((((((StringUtils.capitalise(connectorMetadata.getModuleName())+" ")+ connectorMetadata.getModuleVersion())+" (DevKit ")+ connectorMetadata.getDevkitVersion())+" Build ")+ connectorMetadata.getDevkitBuild())+")"));
            }
        }
        stringList.add((("DevKit Extensions ("+ Integer.toString(extensionsCount))+") used in this application:"));
        stringList.add("");
        logger.info(StringMessageUtils.getBoilerPlate(stringList, '+', 80));
    }

    public void start() {
        splash();
    }

    public void stop() {
    }

    public void dispose() {
    }

}
