
package org.mule.modules.salesforce.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.sforce.async.JobInfo;
import com.sforce.ws.ConnectionException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.salesforce.SalesforceModule;
import org.mule.modules.salesforce.connectivity.SalesforceModuleConnectionManager;


/**
 * CreateBatchMessageProcessor invokes the {@link org.mule.modules.salesforce.SalesforceModule#createBatch(com.sforce.async.JobInfo, java.util.List)} method in {@link SalesforceModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4-SNAPSHOT", date = "2012-07-18T11:29:04-05:00", comments = "Build UNKNOWN_BUILDNUMBER")
public class CreateBatchMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Startable, Stoppable, MessageProcessor
{

    protected Object jobInfo;
    protected JobInfo _jobInfoType;
    protected Object objects;
    protected List<Map<String, Object>> _objectsType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets jobInfo
     * 
     * @param value Value to set
     */
    public void setJobInfo(Object value) {
        this.jobInfo = value;
    }

    /**
     * Sets objects
     * 
     * @param value Value to set
     */
    public void setObjects(Object value) {
        this.objects = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        try {
            findOrCreate(SalesforceModuleConnectionManager.class, true);
            final JobInfo _transformedJobInfo = ((JobInfo) evaluateAndTransform(getMuleContext(), event, CreateBatchMessageProcessor.class.getDeclaredField("_jobInfoType").getGenericType(), null, jobInfo));
            final List<Map<String, Object>> _transformedObjects = ((List<Map<String, Object>> ) evaluateAndTransform(getMuleContext(), event, CreateBatchMessageProcessor.class.getDeclaredField("_objectsType").getGenericType(), null, objects));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) getModuleObject()).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {ConnectionException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((SalesforceModule) object).createBatch(_transformedJobInfo, _transformedObjects);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("createBatch"), event, e);
        }
    }

}
