
package org.mule.modules.salesforce.processors;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import com.sforce.ws.ConnectionException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.salesforce.SalesforceModule;
import org.mule.modules.salesforce.connectivity.SalesforceModuleConnectionManager;


/**
 * PublishTopicMessageProcessor invokes the {@link org.mule.modules.salesforce.SalesforceModule#publishTopic(java.lang.String, java.lang.String, java.lang.String)} method in {@link SalesforceModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4-SNAPSHOT", date = "2012-07-18T11:29:04-05:00", comments = "Build UNKNOWN_BUILDNUMBER")
public class PublishTopicMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Startable, Stoppable, MessageProcessor
{

    protected Object topicName;
    protected String _topicNameType;
    protected Object query;
    protected String _queryType;
    protected Object description;
    protected String _descriptionType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets description
     * 
     * @param value Value to set
     */
    public void setDescription(Object value) {
        this.description = value;
    }

    /**
     * Sets query
     * 
     * @param value Value to set
     */
    public void setQuery(Object value) {
        this.query = value;
    }

    /**
     * Sets topicName
     * 
     * @param value Value to set
     */
    public void setTopicName(Object value) {
        this.topicName = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        try {
            findOrCreate(SalesforceModuleConnectionManager.class, true);
            final String _transformedTopicName = ((String) evaluateAndTransform(getMuleContext(), event, PublishTopicMessageProcessor.class.getDeclaredField("_topicNameType").getGenericType(), null, topicName));
            final String _transformedQuery = ((String) evaluateAndTransform(getMuleContext(), event, PublishTopicMessageProcessor.class.getDeclaredField("_queryType").getGenericType(), null, query));
            final String _transformedDescription = ((String) evaluateAndTransform(getMuleContext(), event, PublishTopicMessageProcessor.class.getDeclaredField("_descriptionType").getGenericType(), null, description));
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) getModuleObject()).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return Arrays.asList(new Class[] {ConnectionException.class });
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((SalesforceModule) object).publishTopic(_transformedTopicName, _transformedQuery, _transformedDescription);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("publishTopic"), event, e);
        }
    }

}
