/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.security.UnauthorisedException;
import org.mule.component.ComponentException;
import org.mule.security.MuleCredentials;
import org.mule.tck.junit4.FunctionalTestCase;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class AuthComponentSynchFunctionalTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "auth-component-synch-test.xml";
    }

    public void doTearDown() {
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl());
    }

    @Test
    public void testCaseGoodAuthenticationGoodAuthorisation() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"marie", (String)"marie", (String)"PBE", (EncryptionStrategy)strategy);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_USER", header);
        MuleMessage m = client.send("vm://test", (Object)"Marie", props);
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((boolean)m.getPayload().equals("Marie"));
    }

    @Test
    public void testCaseGoodAuthenticationBadAuthorisation() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anon", (String)"anon", (String)"PBE", (EncryptionStrategy)strategy);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_USER", header);
        MuleMessage result = client.send("vm://test", (Object)"Marie", props);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(ComponentException.class, result.getExceptionPayload().getException().getClass());
    }

    @Test
    public void testCaseBadAuthentication() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anonX", (String)"anonX", (String)"PBE", (EncryptionStrategy)strategy);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_USER", header);
        MuleMessage result = client.send("vm://test", (Object)"Marie", props);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(UnauthorisedException.class, result.getExceptionPayload().getException().getClass());
    }
}

