/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class AuthorizationFilterTestCase
extends FunctionalTestCase {
    private final String configFile;
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    public AuthorizationFilterTestCase(String configFile) {
        this.configFile = configFile;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"http-transport-filter-test.xml"}, {"http-module-filter-test.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testNotAuthenticated() throws Exception {
        this.doRequest("localhost", this.getUrl(), 401);
    }

    @Test
    public void testAuthenticatedButNotAuthorized() throws Exception {
        this.doRequest(null, "localhost", "anon", "anon", this.getUrl(), false, 403);
    }

    @Test
    public void testAuthorized() throws Exception {
        this.doRequest(null, "localhost", "ross", "ross", this.getUrl(), false, 200);
    }

    @Test
    public void testAuthorizedInAnotherFlow() throws Exception {
        this.doRequest(null, "localhost", "ross", "ross", this.getUrl(), false, 200);
    }

    protected String getUrl() {
        return "http://localhost:" + this.port1.getNumber() + "/authorize";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String host, String url, int result) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(url);
        try {
            int status = client.executeMethod((HttpMethod)get);
            Assert.assertEquals((long)status, (long)result);
            Assert.assertNotNull((Object)get.getResponseHeader("WWW-Authenticate"));
            Assert.assertThat((Object)get.getResponseHeader("WWW-Authenticate").getValue().contains("mule-realm"), (Matcher)Is.is((Object)true));
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String realm, String host, String user, String pass, String url, boolean handshake, int result) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(handshake);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status == 401 && handshake && (status = client.executeMethod((HttpMethod)get)) == 401 && handshake) {
                status = client.executeMethod((HttpMethod)get);
            }
            Assert.assertEquals((long)result, (long)status);
        }
        finally {
            get.releaseConnection();
        }
    }
}

